/*!
 ******************************************************************************
 * @file:   config.c
 * @brief:
 *-----------------------------------------------------------------------------
 *
Copyright (c) 2018 Analog Devices, Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  - Modified versions of the software must be conspicuously marked as such.
  - This software is licensed solely and exclusively for use with processors
    manufactured by or for Analog Devices, Inc.
  - This software may not be combined or merged with other code in any manner
    that would cause the software to become subject to terms and conditions
    which differ from those listed here.
  - Neither the name of Analog Devices, Inc. nor the names of its
    contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.
  - The use of this software may or may not infringe the patent rights of one
    or more patent holders.  This license does not release you from the
    requirement that you obtain separate licenses from these patent holders
    to use this software.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
TITLE, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
NO EVENT SHALL ANALOG DEVICES, INC. OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, DAMAGES ARISING OUT OF CLAIMS OF INTELLECTUAL
PROPERTY RIGHTS INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

#include "inc/admw_config_types.h"

ADMW_CONFIG sensor0_typeK_cjc0_config= {
    .versionId = { .major = 2, .minor = 0 },
    .productId = ADMW_PRODUCT_ID_ADMW1001,
    .admw1001 = {
        .power = {
            .powerMode = ADMW1001_POWER_MODE_ACTIVE,
        },
        .measurement = {
            .operatingMode = ADMW1001_OPERATING_MODE_CONTINUOUS,
            .dataReadyMode = ADMW1001_DATAREADY_PER_CYCLE, // FIX: Temporarily all values from json are hardcoded to this one in the Contracts.FileGenerator - > file translations!!
            .cycleInterval = 0,
            .vBiasEnable = true,
            .RSenseValue = 1000.0,            
        },
        .diagnostics = {
            .disableGlobalDiag = true,
            .disableMeasurementDiag = true,
            .osdFrequency = ADMW1001_OPEN_SENSOR_DIAGNOSTICS_DISABLED,
        },
        .channels = {
            [ADMW1001_CH_ID_ANLG_1_UNIVERSAL] = {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADMW1001_CH_ID_NONE,
                .lutSelect = ADMW1001_LUT_DEFAULT,
                .measurementUnit = ADMW1001_MEASUREMENT_UNIT_CELSIUS,
                .lowThreshold = -50,
                .highThreshold = 250,
                .offsetAdjustment = 0.0,
                .gainAdjustment = 0.0,
                .sensorParameter = 0.0,
                .measurementsPerCycle = 10,
                .cycleSkipCount = 0,
                .extraSettlingTime = 0,
                .priority = 0,
                .adcChannelConfig = {
                    .sensor = ADMW1001_ADC_SENSOR_RTD_2WIRE_PT100,
                    .rtdCurve = ADMW1001_ADC_RTD_CURVE_EUROPEAN,
                    .gain = ADMW1001_ADC_GAIN_1X,
                    .current = {
                        .excitationState= ADMW1001_ADC_EXC_STATE_ALWAYS_ON,
                        .outputLevel = ADMW1001_ADC_EXC_CURRENT_250uA,
                        .diodeRatio = 0,
                    },
                    .filter = {
                        .type = ADMW1001_ADC_FILTER_SINC3,
                        .sf = ADMW1001_SF_8P24HZ,
                        .chopMode = ADMW1001_CHOP_MD_SW,
                        .notch1p2 = false,
                        .groundSwitch = ADMW1001_ADC_GND_SW_OPEN
                    },
                    .reference = ADMW1001_ADC_REFERENCE_VOLTAGE_INTERNAL,
                    .bufferBypass = ADMW1001_BUFFER_BYPASSS_DISABLED,
                },
            },
            [ADMW1001_CH_ID_ANLG_1_DIFFERENTIAL] = {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADMW1001_CH_ID_ANLG_1_UNIVERSAL,
                .lutSelect = ADMW1001_LUT_DEFAULT,
                .measurementUnit = ADMW1001_MEASUREMENT_UNIT_CELSIUS,
                .lowThreshold = -50,
                .highThreshold = 250,
                .offsetAdjustment = 0.0,
                .gainAdjustment = 0.0,
                .sensorParameter = 0.0,
                .measurementsPerCycle = 10,
                .cycleSkipCount = 0,
                .extraSettlingTime = 4499.99986449257,
                .priority = 0,
                .adcChannelConfig = {
                    .sensor = ADMW1001_ADC_SENSOR_THERMOCOUPLE_K,
                    .rtdCurve = ADMW1001_ADC_RTD_CURVE_EUROPEAN,
                    .gain = ADMW1001_ADC_GAIN_8X,
                    .current = {
                        .excitationState= ADMW1001_ADC_EXC_STATE_CYCLE_POWER,
                        .outputLevel = ADMW1001_ADC_NO_EXTERNAL_EXC_CURRENT,
                        .diodeRatio = 0,
                    },
                    .filter = {
                        .type = ADMW1001_ADC_FILTER_SINC3,
                        .sf = ADMW1001_SF_8P24HZ,
                        .chopMode = ADMW1001_CHOP_MD_SW,
                        .notch1p2 = false,
                        .groundSwitch = ADMW1001_ADC_GND_SW_OPEN
                    },
                    .reference = ADMW1001_ADC_REFERENCE_VOLTAGE_INTERNAL,
                    .bufferBypass = ADMW1001_BUFFER_BYPASSS_DISABLED,
                },
            },
        },
    },
};
