#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "mbed.h"
#include "DebouncedIn.h"
#include "TextLCD.h"
#include "QEI.h"
#include "ds3231.h"
#include "Rtc_Ds1307.h"
#include "string.h"
#include <Pulse1.h>
#define ESC 0x1B

/////////////////////////////////     LIB LCD
TextLCD lcd(PTB10, PTB11, PTE2, PTE3, PTE4, PTE5); // rs, e, d4-d7 
// Se debe conectar Vss a GND; VDD a 5V; V0 a pot con otro lado conectado a GND
// El puerto A va hacia una resistencia de 200 hom a 5 V
// EL puerto K va a GND 

Serial pc(USBTX, USBRX); 
/////////////////////////////////   LIB RELOJ 3231
//Ds3231 rtc(PTE0, PTE1); // SDA SCL

Rtc_Ds1307 rtc(PTE0, PTE1);//SCL,SDA
Rtc_Ds1307::Time_rtc tm = {};
time_t epoch_time;
/////////////////////////////////   LIB Encoder

QEI wheel (PTD7, PTD6, NC, 50);
DebouncedIn button_enco(PTC5);
int EncoderInput;
int EncoderBoton;
//////////////////////////////////     Sensor IRDA  
PulseInOut irda(PTD5);// en este puerto se pone el sensor infrarrojo
BusOut leds(LED1,LED2,LED3);
int IRDAInput;
int IRDAOpcion;
/////////////////////////////////////////// Declarar Variables globales 
int OpcionMenu;


void ImprimirHora(){
                    int Hora=0;
                    while(Hora==0){
                    lcd.cls();
                    Rtc_Ds1307::Time_rtc tm = {};
                    rtc.getTime(tm);
                    lcd.locate(0,0);                        
                    lcd.printf("Hora :");
                    lcd.locate(7,0);    
                    lcd.printf("%02d:",tm.hour);
                    lcd.printf("%02d:",tm.min);
                    lcd.printf("%02d",tm.sec); 
                    lcd.locate(0,1);
                    lcd.printf("BY Procesadores ");
                    wait_ms(100);
                        if(button_enco.falling()){
                            Hora=1;
                            }
                    //epoch_time = rtc.get_epoch();
                    //lcd.cls();
                    //lcd.locate(0,0);
                    //lcd.printf(" CLK %s", ctime(&epoch_time));
                    }
}


int LeerEncoder(){
        wheel.reset();
        int Valor=0;
        while(Valor==0){
            EncoderInput=wheel.getPulses();
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("Leyendo Encoder");
            lcd.locate(0,5);
            lcd.printf("Val : %i",wheel.getPulses());
            if(button_enco.falling()){
                EncoderBoton=1;
                EncoderInput=wheel.getPulses();
                pc.printf("Boton %i\n", wheel.getPulses());
                Valor=1;
                }
           wait_ms(50);
        }
        return EncoderInput;
    }

void LeerIRDA(){        
        ////////////////////////  Declaro Variables
                
        int header =0; //tiempo de cabecera pulso abajo
        const int head_H = 10884; //+20% medida con osciloscopio en microsegundos
        const int head_L = 7256;//-20%  medida con osciloscopio
        int i=0;
        const int T_alto=1570;//ponga su tiempo de la prueba
        const int T_bajo=467;//ponga su tiempo de la prueba
        const int num_bits = 32;//ponga su numero de bits
        int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
        int sec[num_bits];//cadena para almacenar la cadena codificada en binario           00100000110111111000100001110111
        int boton1[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,1,0,0,0,1,0,0,0,0,1,1,1,0,1,1,0};    //00100000110111111000100001110110  Boton 1
        int boton2[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,0,1,0,0,1,0,0,0,1,0,1,1,0,1,1,0};    //00100000110111110100100010110110  Boton 2
        int boton3[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,1,1,0,0,1,0,0,0,0,0,1,1,0,1,1,0};    //00100000110111111100100000110110  Boton 3
        int boton4[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,0,0,1,0,1,0,0,0,1,1,0,1,0,1,1,0};    //00100000110111110010100011010110  Boton 4
        int boton5[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,1,0,1,0,1,0,0,0,0,1,0,1,0,1,1,0};    //00100000110111111010100001010110  Boton 5
        int boton6[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,0,1,1,0,1,0,0,0,1,0,0,1,0,1,1,0};    //00100000110111110110100010010110  Boton 6
        int boton7[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,1,0,1,1,0};    //00100000110111111110100000010110  Boton 7
        int boton8[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,0,0,0,1,1,0,0,0,1,1,1,0,0,1,1,0};    //00100000110111110001100011100110  Boton 8
        int boton9[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,1,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0};    //00100000110111111001100001100110  Boton 9
        int boton0[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,0,0,0,0,1,0,0,0,1,1,1,1,0,1,1,0};    //00100000110111110000100011110110  Boton 0
        int botonEnt[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,0,0,1,0,0,0,1,0,1,1,0,1,1,1,0,0};    //00100000110111110010001011011100  Boton Ent
        int botonIzq[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0};    //00100000110111111110000000011110  Boton Izq
        int botonDer[]= {0,0,1,0,0,0,0,0,1,1,0,1,1,1,1,1,0,1,1,0,0,0,0,0,1,0,0,1,1,1,1,0};    //00100000110111110110000010011110  Boton Der
        
        
        int flag1,flag2,flag3,flag4,flag5,flag6,flag7,flag8,flag9,flag0,flagEnt,flagIzq,flagDer; //Banderas de boton presionado
        int dato; // tiempo de cada dato que se lee
        int LeerIRDA=1;
        ////////////////////////////////////////////////////////   Funcion leer datos IRDA
        
        
    leds = 1; // Color en LED Azul
        
        lcd.locate(0,0);
    while(LeerIRDA==1)
    {
ini1:
        pc.printf("Esperando entrada control remoto: \n");
        header=0;
        header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
        if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
        else goto ini1;
 
seguir:
        //leo los datos de la trama y se meten a un arreglo
        wait_us(2000);
        for(i=0; i<(num_bits-1); ++i) // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
        {
            dato = irda.read_high_us(); //leer un bit de datos que es pulso arriba en este control
            num[i]=dato;
            wait_us(332);
        }
        //wait(0.5); //espero un poquito antes de leer todo el arreglo y ponerlo en pantalla
        pc.printf(",%d",header);
        for(i=0; i<num_bits; ++i)
        {
            pc.printf(",%d",num[i]);
        }
        //wait(0.1);  //espero e imprimo en binario
        pc.printf("\n\n");
        for(i=0; i<num_bits; ++i)
        {
            if(num[i] > ((T_alto+T_bajo)/2))
            {
                pc.printf("1");
                sec[i]=1; // guardo la secuancia en binario
            }
            else
            {
                sec[i]=0; //guardo la secuencia en binario
                pc.printf("0");
            }
        }
 
        flag1=1;flag4=1;flag7=1;flag0=1;flagDer=1;
        flag2=1;flag5=1;flag8=1;flagEnt=1;
        flag3=1;flag6=1;flag9=1;flagIzq=1;
        
        for(i=0; i<32; ++i)
        {
            if(sec[i]!=boton1[i]) //en caso de que un bit no coincida se descarta el boton 1
            {
                //pc.printf("NO   Presionaste 1");
                flag1=0;
            }
            if(sec[i]!=boton2[i]) //en caso de que un bit no coincida se descarta el boton 2
            {
                //pc.printf("NO   Presionaste 2");
                flag2=0;
            }
            if(sec[i]!=boton3[i]) //en caso de que un bit no coincida se descarta el boton 3
            {
                //pc.printf("NO   Presionaste 3");
                flag3=0;
            }
            if(sec[i]!=boton4[i]) //en caso de que un bit no coincida se descarta el boton 3
            {
                //pc.printf("NO   Presionaste 3");
                flag4=0;
            }
            if(sec[i]!=boton5[i]) //en caso de que un bit no coincida se descarta el boton 3
            {
                //pc.printf("NO   Presionaste 3");
                flag5=0;
            }
            if(sec[i]!=boton6[i]) //en caso de que un bit no coincida se descarta el boton 3
            {
                //pc.printf("NO   Presionaste 3");
                flag6=0;
            }
            if(sec[i]!=boton7[i]) //en caso de que un bit no coincida se descarta el boton 3
            {
                //pc.printf("NO   Presionaste 3");
                flag7=0;
            }
            if(sec[i]!=boton8[i]) //en caso de que un bit no coincida se descarta el boton 3
            {
                //pc.printf("NO   Presionaste 3");
                flag8=0;
            }
            if(sec[i]!=boton9[i]) //en caso de que un bit no coincida se descarta el boton 3
            {
                //pc.printf("NO   Presionaste 3");
                flag9=0;
            }
            if(sec[i]!=boton0[i]) //en caso de que un bit no coincida se descarta el boton 3
            {
                //pc.printf("NO   Presionaste 3");
                flag0=0;
            }
            if(sec[i]!=botonEnt[i]) //en caso de que un bit no coincida se descarta el boton 3
            {
                //pc.printf("NO   Presionaste 3");
                flagEnt=0;
            }
            if(sec[i]!=botonIzq[i]) //en caso de que un bit no coincida se descarta el boton 3
            {
                //pc.printf("NO   Presionaste 3");
                flagIzq=0;
            }
            if(sec[i]!=botonDer[i]) //en caso de que un bit no coincida se descarta el boton 3
            {
                //pc.printf("NO   Presionaste 3");
                flagDer=0;
            }
        }
        if(flag1==1)
        {
            
            lcd.printf("\n Presionaste 1 \n"); //si coincidieron todos los bits del boton 1
            leds = 2; // Led Color Rosa 
            IRDAInput=1;
            LeerIRDA=0;
        }
        else if(flag2==1)
        {
            leds=2; // Led Color Amarillo
            lcd.printf("\n Presionaste 2 \n"); //si coincidieron todos los bits del boton 1
            IRDAInput=2;
            LeerIRDA=0;
        }
        else if(flag3==1)
        {
            leds=2; // Led Color Verde 
            lcd.printf("\n Presionaste 3 \n"); //si coincidieron todos los bits del boton 1
            IRDAInput=3;
            LeerIRDA=0;
        }
        else if(flag4==1)
        {
            leds=2; // Led Color Verde 
            lcd.printf("\n Presionaste 4 \n"); //si coincidieron todos los bits del boton 1
            IRDAInput=4;
            LeerIRDA=0;
        }
        else if(flag5==1)
        {
            leds=2; // Led Color Verde 
            lcd.printf("\n Presionaste 5 \n"); //si coincidieron todos los bits del boton 1
            IRDAInput=5;
            LeerIRDA=0;
        }
        else if(flag6==1)
        {
            leds=2; // Led Color Verde 
            lcd.printf("\n Presionaste 6 \n"); //si coincidieron todos los bits del boton 1
            IRDAInput=6;
            LeerIRDA=0;
        }
        else if(flag7==1)
        {
            leds=2; // Led Color Verde 
            lcd.printf("\n Presionaste 7 \n"); //si coincidieron todos los bits del boton 1
            IRDAInput=7;
            LeerIRDA=0;
        }
        else if(flag8==1)
        {
            leds=2; // Led Color Verde 
            lcd.printf("\n Presionaste 8 \n"); //si coincidieron todos los bits del boton 1
            IRDAInput=8;
            LeerIRDA=0;
        }
        else if(flag9==1)
        {
            leds=2; // Led Color Verde 
            lcd.printf("\n Presionaste 9 \n"); //si coincidieron todos los bits del boton 1
            IRDAInput=9;
            LeerIRDA=0;
        }
        else if(flag0==1)
        {
            leds=2; // Led Color Verde 
            lcd.printf("\n Presionaste 0 \n"); //si coincidieron todos los bits del boton 1
            IRDAInput=0;
            LeerIRDA=0;
        }
        else if(flagEnt==1)
        {
            leds=5; // Led Color Verde 
            lcd.printf("\n Presionaste Ent \n"); //si coincidieron todos los bits del boton 1
            IRDAInput=3;
            LeerIRDA=0;
        }else if(flagIzq==1)
        {
            leds=5; // Led Color Verde 
            lcd.printf("\n Presionaste Izq \n"); //si coincidieron todos los bits del boton 1
            IRDAInput=3;
            LeerIRDA=0;
        }
        else if(flagDer==1)
        {
            leds=5; 
            lcd.printf("\n Presionaste Der \n"); //si coincidieron todos los bits del boton 1
            IRDAInput=3;
            LeerIRDA=0;
        }
        else
        {
            leds=8; // Led Color Blanco 
            lcd.printf("boton no reconocido"); //si coincidieron todos los bits del boton 1
            IRDAInput=4;
            LeerIRDA=0;
        }
    }
    wait_ms(1000);
    }    
    
    
void Menu(){
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("1_Hora");
    lcd.locate(8,0);
    lcd.printf("3_Alarma");
    lcd.locate(0,1);
    lcd.printf("2_Config Hora");

    wait_ms(1000);
    }    
    
    //////////////////////////////////////// Configurar Reloj /////////////////
void ConfiReloj(){  
            Rtc_Ds1307::Time_rtc tm = {};
            //;config = 0,config = 0,config = 0,ano = 2019,hora = 0, min = 0,
            int configR = 0, cont = 1, set = 0;
            int estado = 1;
            leds=2;
            wait(0.2);
while(estado == 1){
            if(configR == 0) {
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Configurar reloj");
                set = set + wheel.getPulses();
                pc.printf("%i",set);
                wheel.reset();
                if(set > 1) {
                    set = 0;
                }
                if(set < 0) {
                    set = 1;
                }
                lcd.locate(0, 1);
                if(set == 0) {
                    lcd.printf("       NO       ");
                    //wait_ms(10);
                    
                } else if(set == 1) {
                    lcd.printf("       SI       ");
                    //wait_ms(10);
                }
                if(button_enco.falling()){
                    if(set==1){
                        configR=1;
                    }else if(set!=1){
                        configR=0;
                        estado=0;
                        }
            }
            }
            if(configR == 1) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 31) {
                    cont = 1;
                }
                if(cont < 1) {
                    cont = 31;
                }
                lcd.locate(0, 1);
                lcd.printf("Dia: %02d        ", cont);
                tm.date = cont;
                if(button_enco.falling()){
                    
                    configR=2;
                    }
            }
            if(configR == 2) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 12) {
                    cont = 1;
                }
                if(cont < 1) {
                    cont = 12;
                }
                lcd.locate(0, 1);
                lcd.printf("Mes: %02d        ", cont);
                
                if(button_enco.falling()){
                    tm.mon = cont;    
                    configR = 3;
                    }
            }
            if(configR == 3) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 3000) {
                    cont = 2016;
                }
                if(cont < 2016) {
                    cont = 2016;
                }
                lcd.locate(0, 1);
                lcd.printf("Anno: %02d    ", cont);
                
                if(button_enco.falling()){
                    tm.year = cont;    
                    configR = 4;
                    }
            }
            if(configR == 4) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 7) {
                    cont = 1;
                }
                if(cont < 1) {
                    cont = 7;
                }
                lcd.locate(0, 1);
                lcd.printf("Dia semana: %1d", cont);
                //tm.wday = cont;
                
                if(button_enco.falling()){
                    tm.wday = cont;    
                    configR = 5;
                    }
            }
            if(configR == 5) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 23) {
                    cont = 0;
                }
                if(cont < 0) {
                    cont = 23;
                }
                lcd.locate(0, 1);
                lcd.printf("Hora: %02d       ", cont);
                //tm.hour = cont;
                if(button_enco.falling()){
                    tm.hour = cont;    
                    configR = 6;
                    }
            }
            if(configR == 6) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 59) {
                    cont = 0;
                }
                if(cont < 0) {
                    cont = 59;
                }
                lcd.locate(0, 1);
                lcd.printf("Minutos: %02d  ", cont);
                //tm.min = cont;
                if(button_enco.falling()){
                    tm.min = cont;    
                    configR = 7;
                    }
            }
            if(configR == 7) {
                cont = cont + wheel.getPulses();
                wheel.reset();
                if(cont > 59) {
                    cont = 0;
                }
                if(cont < 0) {
                    cont = 59;
                }
                lcd.locate(0, 1);
                lcd.printf("Segundos: %02d  ", cont);
                tm.sec = cont;
                if(button_enco.falling()){
                    tm.sec = cont;    
                    configR = 8;
                    }
            }
            if(configR == 8) {
                lcd.locate(0, 1);
                lcd.printf("  Establecido   ");
                rtc.setTime(tm, false, false);
                rtc.startClock();
                //estado = 0;
                configR = 0;
                estado=0;
                wait(2);
            }
        }
        }
    
    
int main(){
    while(1) {
        pc.printf("Corriendo ...\n");

        Menu();
        wait_ms(1000);
        OpcionMenu = LeerEncoder();
        pc.printf("%i",OpcionMenu);
        switch(OpcionMenu){
            //pc.printf("%i",OpcionMenu);
            case 1:
                // 1 HORA
                ImprimirHora();
            case 2:
                //Configurar hora
                ConfiReloj();
                break;
            case 3:
                // Alarmas
                 break;
            case 4:
                lcd.cls();
                lcd.locate(0,0);
                lcd.printf("Esperando trama");
                lcd.locate(0,1);
                lcd.printf("control remoto");
                LeerIRDA();
                break;
        }        
        //ImprimirHora();
        wait_ms(500);
        //LeerEncoder();
        //wait_ms(50);
        //LeerIRDA();
    }
}
