#ifndef MBED_LED_H
#define MBED_LED_H

#include "mbed.h"


/** LED class.
 *  To use the library, its header file needs to be included and an object of the LED class created.
 
 * Example: Turns the LED0 on. 
 * @code
 * #include "mbed.h"
 * #include "LED.h"
 *
 *  LED gpio(LED0);
 * 
 * int main() {
 *     gpio.ledOn();
 * }

 *  @endcode
 
* Example2: Toggles the LED on and off. 
 * @code
 * #include "mbed.h"
 * #include "LED.h"
 *
 *  LED gpio(LED0);
 * 
 * int main() {
 *  gpio.toggle();
 *  wait(0.2);
 *  gpio.toggle();
 *  wait(0.2);
 * }

 *  @endcode
 
 */


class LED {
public:
 /** The constructor creates an instance of the LED class. It is automatically called when a new object is declared.
        */
    LED(PinName pin);
    /** This function turns led on.
         */ 
    void ledOn();
       /** This function turns led off.
         */ 
    void ledOff();
     /** This function inverts the value of the led.
         */ 
    void toggle();
    
    /** This function makes the led blink on a specific duration.
     *
     * @param duration specifies how long the functions is going to wait during the blink.
     */
     
    void blink(float duration);
  
private:  
    DigitalOut LEDpin;
};
 
#endif
    