#include "mbed.h"
#include "MMA8451Q.h"
#include "tsi_sensor.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif



#define MMA8451_I2C_ADDRESS (0x1d<<1)



/* This defines will be replaced by PinNames soon */
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  #define ELEC0 9
  #define ELEC1 10
#elif defined (TARGET_KL05Z)
  #define ELEC0 9
  #define ELEC1 8
#else
  #error TARGET NOT DEFINED
#endif

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);

    printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z, slide;
        x = abs(acc.getAccX());
        y = abs(acc.getAccY());
        z = abs(acc.getAccZ());
        slide = tsi.readPercentage();
        rled = 1.0f - x;
        gled = 1.0f - y;
        bled = 1.0f - z;
        wait(0.1f);
        if(x > 0.1f) {printf("X: %1.2f\n",x);}
        if(y > 0.1f) {printf("Y: %1.2f\n ",y);}
        if(z > 0.1f) {printf("Z: %1.2f\n",z);}
        if(slide > 0) {printf("Slide: %1.2f\n",slide);}
        
        //printf("X: %1.2f, Y: %1.2f, Z: %1.2f Slider: %1.2f\n", x, y, z,tsi.readPercentage());
    }
}
