/* memo
 * サンプリング1msでは筋電位には遅い？
 * FFTの1kHz以上は取れなくなる
 * 1kHzだとオシロでFFT見た時ぎりぎり
 */
/*** Include ***/
#include "mbed.h"
#include "rtos.h"
#include "FilterTest.h"

#include "typedef.h"

/*** Define ***/
#define ON      (1)
#define OFF     (0)

#define SAMPLING_RATE   (0.001)     /* A/D sampling rate (1kHz) */
#define MAINCYCLE 1000               /* [us] */

#define INT16_MAX     (32767)
#define INT16_MIN     (-32768)
/*
#define DEBUG
#define TESTCOM
*/
union u64_dataType_g {
    double DData;
    char CData[8];
};

union u32_dataType_g {
    float DData;
    char CData[4];
};

/*** Global Variable ***/
DigitalOut  myled1(LED1);           /* 起動確認用 */
DigitalOut  myled2(LED2);           /* 割り込み確認用 */
DigitalOut  myled3(LED3);           /* 休止状態確認用 */
AnalogOut   aout(p18);              /* デバッグ用 */
Ticker      sampling;               /* Interval timer for A/D sampling */
AnalogIn    wave_in(p20);           /* Waveform input */
Serial      pc(USBTX, USBRX);       /* tx, rx */
Timer       timer;
FilterTest  filter;

UINT32      g_sendFlg;
FLT32       g_wave;

UINT32      g_adCnt;

/* 変数定義 */
uint32_t Fdiv;
double InputData = 0.0;

FLT32 g_cntUp;

/*** Functions ***/
/* 通信関数宣言 */
u64_dataType_g Communicaion(double data,int byte);
void CommInit();
double InputAnalgData();
/* A/D変換割り込み宣言 */
void ad_sampling();



INT32 main()
{
    INT32 i = 0;
    INT32 cnt = 0;
    DBL64 st = 0;
    DBL64 et = 0;
    u64_dataType_g sendData;
    myled1 = 1;

    /* 通信初期化 */
    CommInit();     /* 初期化 */

    /* A/D変換対タイマ割り込み開始 */
    myled2 = 1;
    /* Start interval timer */
    sampling.attach(&ad_sampling, SAMPLING_RATE);
    myled2 = 0;

    while(1) {
        /* timer read */
        st = timer.read_us();
        myled3 = 0;

        /* メイン処理 */
        if(cnt >= 1000) {
            myled1 = !myled1;
            cnt = 0;
        }
        cnt++;
        i++;

        /* test */
        //ad_sampling();

        /* データ送信判定 */
        if(g_sendFlg == 1) {
            /* データ送信 */
            i++;
#ifdef DEBUG_
            pc.printf("### cnt: %d, ad cnt: %d, wave: %f hogehoge ###\r\n", i, g_adCnt, InputData);
            aout= (float)InputData;
#endif
#ifdef TESTCOM_
            pc.printf("send: %d,%lf\t\r\n", i,InputData);
#endif
            __disable_irq(); // 禁止
            //InputData = 2.4;
            aout= InputData /* / 3.3*/;
            sendData = Communicaion(InputData,1);
            __enable_irq(); // 許可
            /* フラグリセット */
            g_sendFlg = 0;
            //pc.printf("\r\nsend: %1.8lf, ", sendData.DData);
            for(i=0; i<8; i++) {
                //LPC_UART0->THR =sendData.CData[i];
#ifdef TESTCOM_
                pc.printf("%02x ", sendData.CData[i]);
#endif
            }

        }

        /* timer read */
        et = timer.read_us();
        /* 制御周期まで待機 */
        /*Thread::wait((uint32_t)(MAINCYCLE - (et - st)));*/
        wait_us((uint32_t)(MAINCYCLE - (et - st)));
    }
}

/* A/D変換割り込み */
void ad_sampling()
{
    static INT32 i = 0;
    INT32 hpf_on, lpf_on, brf_on;
    /* 割り込み100回で点滅 */
    if(i >= 100) {
        myled2 = !myled2;
        i = 0;
    }
    i++;
    g_adCnt++;
    InputData = 0.0;
    InputData = InputAnalgData();  /*[V] */

    /* filter */
    hpf_on = 1;
    lpf_on = 1;
    brf_on = 0;
    /** !!! サンプリング周波数確認 !!! **/
    /* InputData = (int32_t)filter.calc( (double)(wave_in.read_u16() - INT16_MAX), hpf_on, lpf_on, brf_on ); */
    // InputData = filter.calc( InputData, hpf_on, lpf_on, brf_on );


#ifdef DEBUG_
    /*pc.printf("attach: %d,%d\r\n", i, InputData);*/
    g_wave = i / 100 * 3.3;
    g_wave = g_adCnt * 3.3;
    if(i > 100) i = 0;
#endif
    /* wait(0.01); */
    /* A/D変換完了後送信 */
    g_sendFlg = 1;
}


void CommInit() /* 通信初期化 */
{
    Fdiv = SystemCoreClock / (4 * 16 * 115200); // 9600bps
}

u64_dataType_g Communicaion(double data,int byte)
{

    int i;
    char header = 0x01;
    char hoge = 0x00;
    u64_dataType_g sendData;
    u32_dataType_g testData;
    /* test */
    g_cntUp = g_cntUp + 0.01;
    if(g_cntUp > 3.0) g_cntUp = 0.0;

    sendData.DData = (float)1.0;
    testData.DData = (float)data;
    //testData.DData = (float)myled1;

    LPC_PINCON->PINSEL0 &= ~(3 << 4);
    LPC_PINCON->PINSEL0 |= (1 << 4);    //  TXD0 (01)

    LPC_SC->PCLKSEL0 &= ~(3 << 6);      // PCLK_UART0 ck/4 (00)
    LPC_SC->PCONP |= (1 << 3);          // PCUART0

    LPC_UART0->LCR |= (1 << 7);         // enable access DLAB
    LPC_UART0->DLL = Fdiv & 0xff;
    LPC_UART0->DLM = (Fdiv >> 8) & 0xff;
    LPC_UART0->LCR &= ~(1 << 7);        // disable access DLAB

    LPC_UART0->LCR |= (3 << 0);         // 8bit
    LPC_UART0->FCR = (7 << 0); // RX1char(00), FIFO reset
    LPC_UART0->IER = (1 << 0); // RBR

    /* send header */
    LPC_UART0->THR = header;
    for(i=0; i<4; i++) {
        //LPC_UART0->THR =sendData.CData[i];
         LPC_UART0->THR =testData.CData[i];
#ifdef TESTCOM_
        pc.printf("send: %d,%lf\r\n", i,sendData.CData[i]);
#endif
    }
    for(i=0; i<3; i++) {
        LPC_UART0->THR = hoge;
    }


    NVIC_EnableIRQ(UART0_IRQn);
    wait_us(100);
    return sendData;
}

double InputAnalgData() /* A/D  読み取り */
{
    double Result = 0.0;

    Result = (double)wave_in.read()  *3.3;
    /*          1 2 3 4 5 6 7 8   */
    // Result = 0x0123456789ABCDEF;
    // Result = 2.0;
    //Result += 1;
    //if(Result > 3) Result = 0;
    /*aout= Result / 3.3;*/
    //wait_us(100);
    return Result;
}

