/* mbed SPI_STMPE610.h to test adafruit 2.8" TFT LCD shiled w Touchscreen
 * Copyright (c) 2014 Motoo Tanaka @ Design Methodology Lab
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef SPI_STMPE610_H
#define SPI_STMPE610_H

#include "mbed.h"

/**
 * STMPE610 Touch Sensor
 * 
 *
 */

class SPI_STMPE610 
{
public:
 /**
 * STMPE610 constructor
 *
 * @param mosi SPI_MOSI pin
 * @param miso SPI_MISO pin
 * @param sclk SPI_CLK pin
 * @param cs   SPI_CS  pin
 */
 SPI_STMPE610(PinName mosi, PinName miso, PinName sclk, PinName cs) ;
 
 ~SPI_STMPE610() ;

 /*
  * some member functions here (yet to be written)
  */

 SPI m_spi;
 DigitalOut m_cs ;
 int _mode ;
 
  void readRegs(int addr, uint8_t *data, int len) ;
  void writeRegs(uint8_t *data, int len) ;
  uint8_t read8(int addr) ;
  void write8(int addr, uint8_t data) ;
  uint16_t read16(int addr) ;
  void write16(int addr, uint16_t data) ;
  
  int getRAWPoint(uint16_t *x, uint16_t *y, uint16_t *z) ;
  
  private:
} ;
#endif /* SPI_STMPE610_H */