#include "player.h"
#include "LM75B.h"
#include <stdio.h>
#include "C12832.h"

// init var and captor
C12832 lcd2(D11, D13, D12, D7, D10);
std::string TYPEStr[3] = {"FIRE", "WATER", "GRASS"};
LM75B sensorTemp(D14,D15);
int temp;

// create player
Player::Player(void) {
    Player(1, 15, FIRE);
}
 
// setters player
Player::Player(uns l, uns att, Type_e t) {
    lvl = l;
    attackDmg = att;
    type = t;
    exp = 0;
    crit = 0.0f;
}
 
// fight function
int Player::fight(Player p) {
    int win = 0;
    uns newAtt = 0;
    if ((p.type == FIRE && type == WATER )|| (p.type == GRASS && type == FIRE) || (p.type == WATER && type == GRASS)) {
            newAtt = 2 * attackDmg;
            if (newAtt >= p.attackDmg) win = 1;
            else if (newAtt < p.attackDmg) win = -1;       
    } else if ((p.type == WATER && type == FIRE) || (p.type == GRASS && type == WATER) || (p.type == FIRE && type == GRASS)) {
            newAtt = (uns)(attackDmg >> 1);
            if (newAtt >= p.attackDmg) win =  1;
            else if (newAtt < p.attackDmg) win =  -1;    
    } else {
           newAtt = attackDmg;
           if (newAtt >= p.attackDmg) win = 1;
           else if (newAtt < p.attackDmg) win = -1; 
    }
    if (win == 1) exp += 20;
    return win;
}

// level up function 
void Player::lvlUp() {
    lvl++;
    attackDmg += 2;
    crit += 0.05f;
    exp = 0;
}

// check exp function
void Player::checkEXP() {
    if (exp >= 100) {
        Player::lvlUp();
    }
}
 
// set the type of pokemon
void Player::setType(Type_e t) {
    type = t;   
    if(t == FIRE){
        temp = sensorTemp.temp();
        if(temp > 28){
            attackDmg = attackDmg+4;
        }
    }
    else if(t==GRASS)
    {
        temp = sensorTemp.temp();
        if(temp < 28 && temp > 18){
            attackDmg = attackDmg+4;
        }
    } 
    else if(t==WATER)
    {
        temp = sensorTemp.temp();
        if(temp < 18){
            attackDmg = attackDmg+4;
        }
    }
        
}

// set text of player
std::string Player::toString(void) {
    std::string res = "STAT: \n" ;
    char num[40];
    char num2[40];
    char num3[40];
    sprintf(num, "Lvl: %u ", lvl);
    snprintf(num3, 40, "Exp: %u ", exp);
    sprintf(num2, "Att: %u \nType: %s", attackDmg, TYPEStr[type].c_str());
    res += num;
    res += num3;
    res += num2;
    return (res);
}