#include "C12832.h"
#include "MMA7660.h"
#include "LM75B.h"
#include "player.h"
#include "mbed.h"
#define BPM 100.0
#define VOLUME 0.01

// init variable
typedef enum State {START, MENU, CHOICE, PLMENU, FIGHT, STATS} GameState;
DigitalOut led(LED1);
DigitalOut red(D5);
DigitalOut blue(D8);
DigitalOut green(D9);
DigitalIn up(A2);
DigitalIn right(A5);
DigitalIn select(D4);
DigitalIn left(A4);
DigitalIn down(A3);
C12832 lcd(D11, D13, D12, D7, D10);
PwmOut pwm_pin(D6);
LM75B sensor(D14,D15);

// playNote function
void playNote(float frequency, float duration, float volume) {
    pwm_pin.period(1.0/frequency);
    pwm_pin = volume/2.0;
    wait(duration);
    pwm_pin = 0.0;
}

// play_music function
void play_music(){
    float beat_duration;

    // Calculate duration of a quarter note from bpm
    beat_duration = 60.0 / BPM;

    // Loop forever
    while(1) {
        
        lcd.cls();
        lcd.locate(0, 10);
        lcd.printf("Luke I'm your father !");

        // First measure
        playNote(391.995, (beat_duration - 0.1), VOLUME);
        wait(0.1);
        playNote(391.995, (beat_duration - 0.1), VOLUME);
        wait(0.1);
        playNote(391.995, (beat_duration - 0.1), VOLUME);
        wait(0.1);
        playNote(311.127, (0.75 * beat_duration), VOLUME);
        playNote(466.164, (0.25 * beat_duration), VOLUME);

        // Second measure
        playNote(391.995, (beat_duration - 0.1), VOLUME);
        wait(0.1);
        playNote(311.127, (0.75 * beat_duration), VOLUME);
        playNote(466.164, (0.25 * beat_duration), VOLUME);
        playNote(391.995, ((2 * beat_duration) - 0.1), VOLUME);
        wait(0.1);

        // Third measure
        playNote(587.330, (beat_duration - 0.1), VOLUME);
        wait(0.1);
        playNote(587.330, (beat_duration - 0.1), VOLUME);
        wait(0.1);
        playNote(587.330, (beat_duration - 0.1), VOLUME);
        wait(0.1);
        playNote(622.254, (0.75 * beat_duration), VOLUME);
        playNote(466.164, (0.25 * beat_duration), VOLUME);

        // Fourth measure
        playNote(369.994, (beat_duration - 0.1), VOLUME);
        wait(0.1);
        playNote(311.127, (0.75 * beat_duration), VOLUME);
        playNote(466.164, (0.25 * beat_duration), VOLUME);
        playNote(391.995, ((2 * beat_duration) - 0.1), VOLUME);
        wait(0.1);
    }
}

// Start Menu
void drawStart() {
    lcd.locate(50,0);
    lcd.printf("PLAY");
    lcd.locate(50, 20);
    lcd.printf("TEMP");
}

// Choice Menu
void drawChoice() {
    lcd.locate(50,0);
    lcd.printf("FIRE");
    lcd.locate(50,10);
    lcd.printf("WATER");
    lcd.locate(50,20);
    lcd.printf("GRASS");
}

// Fight Menu
void drawPlayerMenu() {
    lcd.locate(50,0);
    lcd.printf("FIGHT");
    lcd.locate(50,20);
    lcd.printf("VIEW STAT");
}

// Fight Simulation
void drawFight(Player e, int a, std::string name) {
    std::string sss = e.toString();
    std::string m = "";
    std::string newStr = sss + "\n" + "Name: " + name;
    char z[130];
    strncpy(z, newStr.c_str(), sizeof(z));
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf(z);
    wait(4);
}

// Win View
void win(){
    float beat_duration;

    // Calculate duration of a quarter note from bpm
    beat_duration = 60.0 / BPM;
        
    lcd.cls();
    lcd.locate(0, 10);
    lcd.printf("You won and \nyou got 20 exp points !");
    
    playNote(1319,beat_duration-0.1,VOLUME);
    wait(0.1);
    playNote(1175,beat_duration-0.1,VOLUME);
    wait(0.1);

    playNote(1319,beat_duration-0.1,VOLUME);
    wait(0.1);

    playNote(1024,beat_duration-0.1,VOLUME);
    wait(0.1);

    wait(0.05);
}

// Loose View
void loose (){
    lcd.cls();
    lcd.locate(50, 10);
    lcd.printf("LOOSE");   
}

// Init Var
int i = 0;
int k = 0;
int v = 0;
int r = 0;
int l = 0;

// Main function
int main() {
    
    //Reset Captor
    led = 0;
    red = 1;
    blue = 1;
    green = 1;
    
    // Create Player
    Player pl(1, 20, FIRE);
    
    // Create Enemy
    std::string nameList[42] = {"Abra", "Absol", "Azelf", "Banette", "Bastiodon", "Beautifly", "Bidoof", "Carvanha", "Clefairy", "Cresselia", "Crobat", "Darkrai", "Delphox", "Dialga", "Ditto", "Doduo", "Dratini", "Dugtrio", "Gothitelle", "Grovyle", "Haxorus", "Honedge", "Hoopa", "Jirachi", "Keldeo", "Lugia", "Makuhita", "Marill", "Meowth", "Minun", "Remoraid", "Rhyhorn", "Sableye", "Sandile", "Sawk", "Sylveon", "Tauros", "Togepi", "Victini", "Wailord", "Wingull", "Zubat"};
    Player enemy[6] = {Player(1, 15, FIRE), Player (1, 20, WATER), Player(1, 15, GRASS), Player(2, 10, FIRE), Player(4, 20, WATER), Player(2, 20, GRASS)};    
    
    // Draw Start Menu
    GameState state = START;
    up.mode(PullUp);
    down.mode(PullUp);
    select.mode(PullUp);
    lcd.locate(40,0);
    lcd.printf(">");
    drawStart();

    // Principal loop
    while(1){

        // Start Menu
        if(state == START){
            if(up){
                lcd.cls();
                lcd.locate(40,0);
                lcd.printf(">");
                drawStart(); 
                i=0;
            }
            else if(down){
                lcd.cls();
                lcd.locate(40,20);
                lcd.printf(">");
                drawStart(); 
                i=1;
            }
            else if(right){
                r=3;
            }
            else if(left){
                l=3;
            }
            // Select Menu
            else if(select){

                if(r == 3 && l == 3 && i==0){
                    play_music();
                }
                else
                {
                    
                    if(i==0){
                        wait(0.8);
                        state = CHOICE;
                        drawChoice();
                    }
                    else{
                        lcd.cls();
                        lcd.locate(0,3);
                        lcd.printf("Temp = %.1f\n", sensor.temp());
                        wait(1.0);
                        i = 0;
                        lcd.cls();
                        lcd.locate(40,0);
                        lcd.printf(">");
                        drawStart(); 
                    }
                }
            }
            
        }//if state == START
        
        // Choice Menu
        else if(state == CHOICE){
            
            if(down){
                if(k==0)
                {
                    lcd.cls();
                    lcd.locate(40,10);
                    lcd.printf(">");
                    drawChoice();
                    k = 1;
                    wait(0.8);
                }
                else if(k==1)
                {
                    lcd.cls();
                    lcd.locate(40,20);
                    lcd.printf(">");
                    drawChoice(); 
                    k = 2;
                    wait(0.8);
                }
            }// if down
            
            else if(up){
                if(k==2){
                    lcd.cls();
                    lcd.locate(40,10);
                    lcd.printf(">");
                    drawChoice(); 
                    k=1;
                    wait(0.8);
                }
                else if(k==1){
                    lcd.cls();
                    lcd.locate(40,0);
                    lcd.printf(">");
                    drawChoice(); 
                    k=0;
                    wait(0.8);
                }
            }// else if up
            
            // Select Type
            else if(select){
                if(k==0){
                    pl.setType(FIRE);
                    red = 0;
                    blue = 1;
                    green = 1;
                }
                else if(k==1){
                    pl.setType(WATER);
                    red = 1;
                    blue = 0;
                    green = 1;
                }
                else if(k==2){
                    pl.setType(GRASS);
                    red = 1;
                    blue = 1;
                    green = 0;
                }
                wait(0.8);
                lcd.cls();
                lcd.locate(40,0);
                lcd.printf(">");
                drawPlayerMenu();
                state = PLMENU;
            }
        }// if state == choice
        
        // Fight Menu
        else if(state == PLMENU){
            if(up){
                lcd.cls();
                lcd.locate(40,0);
                lcd.printf(">");
                drawPlayerMenu(); 
                v=0;
            }
            else if(down){
                lcd.cls();
                lcd.locate(40,20);
                lcd.printf(">");
                drawPlayerMenu(); 
                v=1;
            }
            
            else if(select){
                wait(0.8);
                if(v==0){
                    state = FIGHT;
                }
                else{
                    state = STATS;
                }
            }
        
        }// if state == PLMENU
        
        // Fight 
        else if(state == FIGHT){
            // Rand Enemy
            int ind = rand() % 6;
            int ind2 = rand() % 42;
            std::string str = nameList[ind2];
            Player ene = enemy[ind];
            // Fight Simu
            int w = pl.fight(ene);
            // Check Exp
            pl.checkEXP();
            drawFight(ene, w, str);
            
            // Result
            if(w==1){
                wait(0.8);
                win();
                state = PLMENU; 
            }
            else{
                wait(0.8);
                loose();
                state = PLMENU; 
            }
            
        }//if state == FIGHT
        
        // View Stat
        else if (state == STATS) {
            std::string sss = pl.toString();
            char c[50];
            strncpy(c, sss.c_str(), sizeof(c));
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf(c);
            wait(3);

            lcd.cls();
            state = PLMENU;
        }// if state == MENU
        
        
    }// while 1        

}
