// Simple Example fo use of Threads on mbed OS 5
//   Only need to include mbed.h

#include "mbed.h"

#include "rtos.h"

Serial pc(USBTX, USBRX); // tx, rx
// Variable for a second thread
Thread thread;

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);

int speed = 200; // global variable
// This method is run in the second thread
void ledB_thread() {
    
    // serial
    
    char c ;
    pc.printf("Enter a character>");
    while(1) {
        myled1 = 1;  // turn on
        c = pc.getc();
        pc.putc(c);
        pc.putc('\r');
        pc.putc('\n');
        Thread::wait(200);
        pc.printf("Enter 'S' for slower and 'F' for faster : ");
        pc.putc('\n');

// 200ms, 400ms, 800ms and 1600ms

        if(c == 'f'){
            
              speed /= 2;
              
              // interlocking
              if (speed <=200){ speed = 200;}
              
            
            }else if(c == 's'){
                
              speed *= 2;
            
              // interlocking
              if (speed >=1600){ speed = 1600;}
            }
            
            
        
//yled1 = 0;  // turn off
}
//
//    while (true) {
//        Thread::wait(1000);
//        myled1 = 1;
//    }
}

// This is the main thread
int main (void) {
    
    
    // start the second thread
    thread.start(callback(ledB_thread));
    
    
// blinky led in step 3

    int state = 1;
    while(1) {
        Thread::wait(speed);
        switch(state){
//            case 0:
//                Thread::wait(1500);
//                myled1 = 1;
//
//            break;

            case 1:


                myled1 = 1; // turn off

                myled2 = 1;

                myled3 = 1;


            break;

            case 2:


                myled1 = 0; // turn on

                myled2 = 1;

                myled3 = 1;




            break;

            case 3:


                myled1 = 0; // turn on

                myled2 = 0;

                myled3 = 1;


            break;

            case 4:

                myled1 = 0; // turn on

                myled2 = 0;

                myled3 = 0;


            break;

            }

        state ++;

        if(state >4){
        state =1 ;
        }
    }


//
//    while (true) {
//        Thread::wait(400);
//        // blinky led
//        
//        
//        
//        
//        
//        ledA = !ledA;
//    }
}
