#include "mbed.h"

// Labs 2: Example program for polling an input
// --------------------------------------------
// The program uses a thread to poll a digital input
//   - The thread monitors the position of the button
//   - When the button transitions up and down, a press event is signaled 
//   - Button bounce is guarded against
// A second thread (the default one) checks for the press event and toggles the LED

DigitalIn b1(PTD0, PullUp);
DigitalOut  yled(LED1);

Thread pollT ; // thread to poll
volatile int pressEvent = 0 ;  // Variabe set by the polling thread

enum buttonPos { up, down, bounce }; // Button positions // three options of button position

void polling() {
    buttonPos pos = up ;// initial position
    int bcounter = 0 ;
    while (true) {
        switch (pos) {
            case up :
                if (!b1.read()) {    // now down 
                    pressEvent = 1 ;  // transition occurred
                    pos = down ; // action and update position
                }
                break ;
            case down : 
                if (b1 == 1) { // no longer down. what the default value of b1?- > it depends and doesnt have initial value
                    bcounter = 3 ; // wait four cycles
                    pos = bounce ;
                }
                break ;
            case bounce :
                if (b1 == 0) { // down again - button has bounced
                    pos = down ;   // no event
                } else if (bcounter == 0) {
                    pos = up ;     // delay passed - reset to up
                } else {
                    bcounter-- ;   // continue waiting
                }
                break ;
        }
        Thread::wait(30);
    }
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    led = 1 ;  // Initially off
    pollT.start(callback(polling));
    int speed = 200; // global variable


    while(true) {
        if (pressEvent) { // main event
            pressEvent = 0 ; // clear the event variable
             
           // led = !led ;
//            Thread::wait(100) ; // time to apply
//            
            speed += 200;
            
            if(speed>1000){
                speed =200;
            }
        }
        
        Thread::wait(speed) ;
        led = !led ;
        
//        
    }
}