#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn button(PTD0);

InterruptIn button2(PTD2);
DigitalOut led1(LED_RED);
DigitalOut led2(LED_BLUE);


volatile int pressEvent1 = 0 ;

volatile int pressEvent2 = 0 ;

// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur
void buttonCallback1(){


    pressEvent1 = 1 ;


}
void buttonCallback2(){
   
    pressEvent2 = 1 ;


}
/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    button.mode(PullUp);             // Ensure button i/p has pull up
    button.fall(&buttonCallback1) ;   // Attach function to falling edge


    button2.mode(PullUp);             // Ensure button i/p has pull up
    button2.fall(&buttonCallback2) ;   // Attach function to falling edge

    bool flash1 = true;

    bool flash2 = true;


//    bool cycle = false; //
    

    bool check_flash1 = true; // check flash one ==> make flash 1 only change once in each cycle
    
    bool check_flash2 = true; // check flash one ==> make flash 1 only change once in each cycle

    while(true) {
  
          
        // Toggle the LED every time the button is pressed
        if (pressEvent1 and check_flash1) {

           // led1 = 1 ; //eend turn off light as default
            flash1 = !flash1 ;

            pressEvent1 = 0 ; // Clear the event variable

            // dealing with bounce
            check_flash1 = false;

        }

        // Toggle the LED every time the button is pressed
        if (pressEvent2 and check_flash2) {

            //led2 = 1 ; //eend turn off light as default
            flash2 = !flash2 ;

            pressEvent2 = 0 ; // Clear the event variable

            // dealing with bounce
            check_flash2 = false;
        }


        if(flash1){ 
            
            led1 = !led1 ;

        }

        if(flash2){

            led2 = !led2 ;
        }
      
        
        Thread::wait(500) ; // 2x?
        
        // every cycle, just make  1 instruction
        
        check_flash1 = true;
        
        check_flash2 = true;

    }
}
