#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)

 PinName const SDA = PTE25;
 PinName const SCL = PTE24;
 
Timer t; // for timer


DigitalOut ledRed(LED_RED);
DigitalOut ledGreen(LED_GREEN);

PwmOut rled(LED1);
PwmOut gled(LED2);
PwmOut bled(LED3);

bool flat = false;

bool right = false;

bool left = false;

bool up = false;

bool down = false;

bool over = false;

bool intermediate = false;

bool errorr = false;

float timer ;

Serial pc(USBTX, USBRX); // tx, rx



MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
Thread thread2 ; // create a second thread

void led2_thread() {  // method to run in thread

  
 
//    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());
    
    t.start(); // start timer


    while (true) {
        float x, y, z;
        
        float lower_th, upper_th;
        
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        
        //
        Thread::wait(300);
        
        if(z>= 0.9 ){ // flat
           // myled1 = 0;
           //
//            rled = 1.0f - abs(x);
//            gled = 1.0f - abs(y);
//            bled = 1.0f - abs(z);
//            
            
            flat = true ; // send status to main thread
            
            timer = t.read();//send timer 
            
            pc.printf("flat : %f \n \r", t.read());
                        
        }else if(y>= 0.9 ){//right
           //
//            rled = 1.0f - abs(x);
//            gled = 1.0f - abs(y);
//            bled = 1.0f - abs(z);
//            
            
            right = true ; // send status to main thread
            
            pc.printf("right : %f \n \r", t.read());
            
        }else if(x>= 0.9){ // dowm
            
           //
//            rled = 1.0f - abs(x);
//            gled = 1.0f - abs(y);
//            bled = 1.0f - abs(z);
            
            down = true ; // send status to main thread
            
            timer = t.read();//send timer 
            
            pc.printf("down : %f \n \r", t.read());
            
        }else if(z<= -0.90 ){ //over
            
           //
//            rled = 1.0f - abs(x);
//            gled = 1.0f - abs(y);
//            bled = 1.0f - abs(z);
//            
            
            over = true ; // send status to main thread
            
            timer = t.read();//send timer 
            
            pc.printf("over : %f \n \r", t.read());
            
        }else if(y<= -0.90 ){ //left
            
                       //
//            rled = 1.0f - abs(x);
//            gled = 1.0f - abs(y);
//            bled = 1.0f - abs(z);
            
           
            left = true ; // send status to main thread
            timer = t.read();//send timer 
            pc.printf("left : %f \n \r", t.read());
            
            
        }else if(x<= -0.90 ){ // up
            //
//                       
//            rled = 1.0f - abs(x);
//            gled = 1.0f - abs(y);
//            bled = 1.0f - abs(z);
            
            up = true ; // send status to main thread
            timer = t.read();//send timer 
            pc.printf("up : %f \n \r", t.read());
            
        }
        
        else{
            
            t.reset(); // timer reset count
            rled = 1;
            gled = 1;
            bled =1;
            
            timer = t.read();//send timer 
            pc.printf(" \n \r");
        }
        //
       // pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f \n \r", x, y, z);
    
    
    }// end while
    
    t.stop(); // timer stop
    
}
 
 
int main(void)
{//
//
//bool flat = false;
//
//bool right = false;
//
//bool left = false;
//
//bool up = false;
//
//bool down = false;
//
//bool over = false;
//
//bool intermediate = false;
//
//bool errorr = false;

    bool trigger = false;
    
    thread2.start(&led2_thread) ; // thread for chceking accelerometer
    
    // main logic depends on diagram
    if(timer >= 9.8 ){
        
    }
    else{
        
    }
    
    

    
}