
// LAB 3 SAMPLE PROGRAM 1
//   Revised for mbed 5

#include "mbed.h"


Ticker tick;                // Ticker for reading analog
AnalogIn ain(A0) ;          // Analog input
DigitalOut led1(LED_RED);   // Red LED

DigitalOut ledex1(D8);
DigitalOut ledex2(D9);
DigitalOut ledex3(D10);
DigitalOut ledex4(D11);
DigitalOut ledex5(D12);
DigitalOut ledex6(D13);


Serial pc(USBTX, USBRX); // tx, rx, for debugging

DigitalIn b1(PTD4, PullUp); // for button

// polling 

Thread pollT ; // thread to poll
volatile int pressEvent = 0 ;  // Variabe set by the polling thread

enum buttonPos { up, down, bounce }; // Button positions // three options of button position

void polling() {
    buttonPos pos = up ;// initial position
    int bcounter = 0 ;
    while (true) {
        switch (pos) {
            case up :
                if (!b1.read()) {    // now down 
                    pressEvent = 1 ;  // transition occurred
                    pos = down ; // action and update position
                }
                break ;
            case down : 
                if (b1 == 1) { // no longer down. what the default value of b1?- > it depends and doesnt have initial value
                    bcounter = 3 ; // wait four cycles
                    pos = bounce ;
                }
                break ;
            case bounce :
                if (b1 == 0) { // down again - button has bounced
                    pos = down ;   // no event
                } else if (bcounter == 0) {
                    pos = up ;     // delay passed - reset to up
                } else {
                    bcounter-- ;   // continue waiting
                }
                break ;
        }
        Thread::wait(10);
    }
}


// Message type
typedef struct {
  uint16_t analog; /* Analog input value */ 0 - 65.535
} message_t;

// Mail box
Mail<message_t, 2> mailbox;

// Function called every 10ms to read ADC
// Low pass filter  
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ; 
void readA0() {
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ; // smuthing function
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
        }
        samples = 0;
    }       
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s) {    
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}

// Main program
//   Initialise variables
//   Attach ISR for ticker
//   Procss messages from mailbox    
int main() {
    led1 = 1 ; // turn off 
    bool max_power = false;
    int volts = 0 ;
    bool change_detector = false;
  //  const int threshold = 100 ;
    pollT.start(callback(polling));


    const int threshold1 = 55;
    const int threshold2 = 110;
    const int threshold3 = 165;
    const int threshold4 = 220;
    const int threshold5 = 275;
    
    const int threshold6 = 330;
    
    int counter = 0 ;
    char vstring[] = "X.XX\r\n" ;

    tick.attach_us(callback(&readA0), 10000); // ticks every 10ms
    while (true) {
        osEvent evt = mailbox.get(); // wait for mail 
        
        

    if (pressEvent) { // main event
            pressEvent = 0 ; // clear the event variable
           // ledex6 = !ledex6 ;
            //volts = 330;
            max_power = !max_power;
            change_detector = false;
        }
        
        if (evt.status == osEventMail) {
            message_t* mess = (message_t*)evt.value.p ;
            volts = (mess->analog * 330) / 0xffff ;
            mailbox.free(mess) ;  // free the message space
            
            
            
            if ( volts <= threshold1  and max_power == false) {
                                
                    ledex1 = 0;
                    ledex2 = 0;
                    ledex3 = 0;
                    ledex4 = 0;
                    ledex5 = 0;
                   // ledex6 = 0;
            }
            else if (volts <= threshold2 and max_power == false) {
                                
                    ledex1 = 1;
                    ledex2 = 0;
                    ledex3 = 0;
                    ledex4 = 0;
                    ledex5 = 0;
//                    ledex6 = 0;
            }
            else if (volts <= threshold3 and max_power == false) {
                                
                    ledex1 = 1;
                    ledex2 = 1;
                    ledex3 = 0;
                    ledex4 = 0;
                    ledex5 = 0;
//                    ledex6 = 0;
            } 
            
            else if (volts <= threshold4 and max_power == false) {
                                
                    ledex1 = 1;
                    ledex2 = 1;
                    ledex3 = 1;
                    ledex4 = 0;
                    ledex5 = 0;
//                    ledex6 = 0;
            }  
            else if (volts <= threshold5 and max_power == false) {
                                
                    ledex1 = 1;
                    ledex2 = 1;
                    ledex3 = 1;
                    ledex4 = 1;
                    ledex5 = 0;
                    //ledex6 = 1;
                    
            }else if (volts >= threshold6 or max_power == true) {
                                
                    ledex1 = 1;
                    ledex2 = 1;
                    ledex3 = 1;
                    ledex4 = 1;
                    ledex5 = 1;
//                    ledex6 = 1;
                    if(volts >= threshold5){
                        
                         max_power = false;
                    
                    }        
            
            } 
            else {
                
             
                
            }
            // this is the main logic
            
            
            vToString(volts, vstring) ;
            counter++ ;
            if (counter == 10) {  // limit bandwidth of serial
                pc.printf(vstring) ;
                counter = 0 ;
            }
        }

    }
}
