#define START_ADDRESS 0x020;
#define MISO_PIN PTE3

/**************Defining Counter Limits**************/

#define THRS 20
#define STATE_ERR_THRS 20
#define PHY_OFF_EXEC_TIME 300
#define PHY_ON_EXEC_TIME 300
#define PHY_TX_EXEC_TIME 600
/******DEFINING COMMANDS*********/

#define CMD_HW_RESET 0xC8
#define CMD_PHY_ON 0xB1
#define CMD_PHY_OFF 0xB0
#define CMD_PHY_TX 0xB5
#define CMD_CONFIG_DEV 0xBB
#define PH_THRS 3
#define HW_THRS 3
/********COMMAND LINES and #defined functions**********************/
#define STATUS_CHECK CS=0; adf.write(0xFF); stat = adf.write(0xFF); CS=1;
#define CMD_PHY_OFF_FUNC CS=0; adf.write(CMD_PHY_OFF); CS=1;
#define CMD_HW_RESET_FUNC CS=0; adf.write(CMD_HW_RESET); CS=1;
#define CMD_PHY_ON_FUNC CS=0; adf.write(CMD_PHY_ON); CS=1;
#define CMD_PHY_TX_FUNC CS=0; adf.write(CMD_PHY_TX); CS=1;
/*****FUNCTION Declaration********************/
bool config_flag=0;
bool assrt_phy_off( int, int, int);
bool assrt_phy_on( int,int,int);
bool assrt_phy_tx(int,int,int);
bool config_f(void);
/****************************/
SPI adf(PTE1, PTE3, PTE2); //MOSI, MISO, CLOCK
//SPI adf(PTA16, PTA17, PTA15); //MOSI, MISO, CLOCK
//DigitalOut CS(D10);
DigitalOut CS(PTA15);
DigitalOut led2(LED_RED);
//InterruptIn IRQ(D8);
InterruptIn IRQ(PTA14);
Ticker ticker;
unsigned char d = 0,c=1; 
unsigned char k = 0;
unsigned char bbram_buffer[66]={0x19,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x00,0xF4,0xC2,0x10,0xC0,0x00,0x30,0x31,0x07,0x00,0x01,0x00,0x7F,0x00,0x0B,0x37,0x00,0x00,0x40,0x0C,0x00,0x05,0x00,0x00,0x18,0x12,0x34,0x56,0x10,0x10,0xC4,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00};

unsigned int state_err_cnt=0;
unsigned int hw_reset_err=0;
unsigned int phy_off_err=0;
unsigned int phy_on_err=0;
unsigned int phy_tx_err=0;

unsigned char stat=0;

/*******ADDITIONAL STUFF****************/    
    
    
/*****************************************/

bool config_f(){
    hw_reset_err++;
    if(hw_reset_err>HW_THRS){
        return 1;//1 == NOT CONFIGURED   0 == CONFIGURED
        }
    phy_off_err=0;
    phy_on_err=0;
    phy_tx_err=0;
    
while(phy_off_err<PH_THRS){
    STATUS_CHECK
    if(stat==0xB1){
        break;
        }
    else{
        CMD_PHY_OFF_FUNC
        }
    }
        
if(phy_off_err >= PH_THRS){
    return config_f();
    }
    
    bbram_write();
    initiate();
    CMD_PHY_ON_FUNC

    while(phy_on_err<PH_THRS){
    STATUS_CHECK
    if(stat==0xB2){
        break;
        }
    else{
        CMD_PHY_ON_FUNC
        }
    }

if(phy_on_err >= PH_THRS){
    return config_f();
    }
return 0; // 0 --> Configured 1--->not configured
}
/*****************************/

void bbram_write()
{   
    CS=0;
    adf.write(0xB0);//PHY_OFF
    wait_us(300);
    CS=1;
    
    // Write bbram
    CS=0;
     for(int i=0;i<66;i++){
        adf.write(bbram_buffer[i]);    
    }
    CS=1;
//    wait(1);
    
}




/******************************************************************************************/

void initiate(void){
    
    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
//    wait_ms(2);

    CS=0;
    adf.write(0x08);    // TRANSMIT_DATA LENGTH
    adf.write(0x14);
    adf.write(0xFF);
    CS=1;
//    wait_ms(2);
    CS=0;
    adf.write(0x08);        // TRANSMIT_DATA LENGTH
    adf.write(0x15);
    adf.write(0xFF);
    CS=1;
//    wait_ms(2);
    
    CS=0;
    adf.write(0x09);
    adf.write(0x24);   // TX_BASE ADDRESS   0x20(starting Tx Byte)
    adf.write(0x20);
    CS=1;
//    wait_ms(2);
    
    CS=0;
    adf.write(0x09);
    adf.write(0x37);// BUFFER SIZE 0xE0=224 Bytes 0x137 is adress of buffer size
    adf.write(0xE0);
    CS=1;
//    wait_ms(2);
    
    CS=0;
    adf.write(0x09);
    adf.write(0x36);//BB_Tx_Buffer Signal when Buffer is half filled
    adf.write(0x70);//0x70 = 112 >> When Half buffer interrupt is given
    CS=1;
//    wait_ms(2);
    
    
    CS=0;
    adf.write(0x09);
    adf.write(0x39);//BB_Tx_Buffer Signal when Buffer is half filled
    adf.write(0x10);//0x70 = 112 >> When Half buffer interrupt is given
    CS=1;
//    wait_ms(2);    
    }

 

void write_data(void){
   
//    wait_ms(0);
    CS=0;
    adf.write(0x0B);//IRQ_SOURCE_Random write //To read CMD = 2B 36 FF FF
    adf.write(0x36);//Address : 0x336
    adf.write(0xFF);//Put Low
    CS=1;
//    wait_us(80);
    CS=0;
    static bool first_2_time = true;
    k=0;
 
    if(!first_2_time){
               if(d==1 && snd_tm.last_buffer==false){
//                cout<<"3"<<ENDL;
                adf.write(0x18);
                adf.write(0x20);
                while(k<112)
                {
                adf.write(snd_tm.transmit[k]);  
                k++;
                }
                d=2;
                }
                   
    
            else  if(d==2 && snd_tm.last_buffer==false){     
//                    cout<<"4"<<ENDL;
                    adf.write(0x18);
                    adf.write(0x90);
                    while(k<112)
                    {
                        adf.write(snd_tm.transmit[k]);  
                        k++;
                    }
                    d=1;   
         
              }   
     
        
    }
 
    if(first_2_time){
        switch(c){
        case 1:  
//           cout<<"1"<<ENDL;
                    adf.write(0x18);
                    adf.write(0x20);
                    while(k<112)
                    {
                    adf.write(snd_tm.transmit[k]);  
                    k++;
                    }
                    c++;
                    break;   
        
        case 2:    
//         cout<<"2"<<ENDL;
                        adf.write(0x18);
                        adf.write(0x90);
                        while(k<112)
                        {
                            adf.write(snd_tm.transmit[k]);  
                            k++;
                        }
                        c++;
                        d=1;
                        first_2_time = false;
                     break;   
                     }   
            
     }
                 
     
            
      if(snd_tm.last_buffer){
                CS=0;
                adf.write(0x18);
                adf.write(0x20);
               
                while(k<112){
                    adf.write(snd_tm.transmit[k]);  
                    k++;
                }
                CS=1;
//            //        
                snd_tm.transmission_done=true;
                //ticker.detach();
//                wait_ms(60);
//                CS=0;
//                 adf.write(0xB1);
//                CS=1;
//                snd_tm.transmission_done=true;
        }
                          
     CS=1;
//     wait_us(1);
    }
    


void check()
    {   
     
     if(IRQ){
         if(snd_tm.transmission_done==false){
             write_data();
             snd_tm.transmit_data();
         }
         else{
                ticker.detach();
                CS=0;
                 adf.write(0xB1);
                CS=1;
//                snd_tm.transmission_done=true;
             }
         }
     }

void send_data(void){
        
    CS=0;
    adf.write(0xBB);
    CS=1;
//    wait_us(300); 
    
    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
//    wait_ms(2); 
    snd_tm.transmit_data();
//    wait_ms(1);
    write_data();
//    wait_ms(1);
    snd_tm.transmit_data();
//    wait_ms(1);
    write_data();
    snd_tm.transmit_data();
//    snd_tm.transmit_data();
//    write_data();
//  wait_ms(2);  
    CS=0;
    adf.write(0xB1);
    CS=1;
    wait_us(300); 
    
    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
//    wait_ms(2);  
    
    CS=0;
    adf.write(0xB5);
    CS=1;
    printf("b5 gien\n");
    wait_us(300);  
//    int b5=t.read_us();
    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
//    wait_ms(2);
    
    ticker.attach_us(&check,32000);
    }
    
    void adf_callme(){
        adf.format(8,0);
        adf.frequency(1000000);
        printf("inside callme");
        bool state_0=0;
        config_f();
        send_data();
    
        while(!snd_tm.transmission_done)
        {
                led2=!led2;
                wait(.1);
        }
    }