#include "mbed.h"
#include <iostream>
using namespace std;
#include <bitset>

#define ENDL "\r" << endl;
#define START_ADDRESS 0x020;



//SPI

SPI adf(PTD6, PTD7, PTD5);
//MOSI, MISO, CLOCK

DigitalOut CS(D10);
Serial PC(USBTX, USBRX);
DigitalOut ledr(LED_RED);

DigitalIn clk(D8);
DigitalOut DT(D9);
int j=0;
int bitcount=1;
int times=0;
int bites=0;

#define SPI_NOP 0xFF

enum con_type{ packet=0x18, bbram=0x19, mcr=0x1B, program=0x1E };
enum discon_type{ packet2=0x08, bbram2=0x09, mcr2=0x0B };

enum discon_type_RD{ packet3=0x28, bbram3=0x29, mcr3=0x2B };

unsigned char data_TX [] = {0x65,0xD3,0x06,0x08,0xBB,0xE7,0xCD,0x16,0x65,0xD3,0x06,0x08,0xBB,0xE7,0xCD,0x16,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x20,0xE5,0xEE,0x00,0xEB,0x3D,0x35,0x66,0xDC,0xDA,0x33,0xA1,0x80,0x62,0xB7,0xB8,0x88,0x8A,0xCE,0x99,0x18,0xFA,0x24,0x42,0xD1,0x7C,0x2D,0x0E,0x72,0x9E,0xE9,0x7C,0xF9,0xBA,0x18,0xAA,0x4B,0xEC,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x20,0xE5,0xEE,0x00,0xCC,0xB3,0xB2,0x5B,0x96,0x38,0x71,0x96,0x54,0xE2,0x4A,0x7F,0xC9,0xB7,0x1E,0x56,0x09,0x30,0x18,0x5A,0x84,0xFA,0xC1,0x9D,0xA6,0x6A,0x17,0x50,0x6F,0xD4,0x34,0x1D,0xF0,0xE0,0xE2,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x20,0xE5,0xEE,0x00,0x78,0xC9,0x9A,0x09,0xE2,0x34,0xF9,0x39,0x61,0x36,0x9C,0xC2,0x98,0xB9,0x54,0xC0,0xDC,0xE6,0x90,0xF6,0xF6,0x88,0xD1,0xA5,0x5A,0x75,0x83,0x78,0x08,0xD6,0x9D,0xDE,0xB8,0x58,0xD4,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x20,0xE5,0xEE,0x00,0x13,0x3F,0x78,0xD9,0x4E,0xB7,0xE8,0xD6,0x0D,0x1E,0xF1,0xC4,0xB9,0xAB,0x90,0x39,0x6A,0x9E,0x8A,0xB8,0xC9,0xAF,0x5E,0x85,0x66,0xBF,0x4E,0xB3,0xD3,0x54,0x9B,0x7D,0xA3,0x3A,0x1A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x20,0xE5,0xEE,0x00,0x81,0x83,0x7B,0x88,0x8A,0xAB,0x31,0x91,0x8F,0xA0,0x91,0x05,0x17,0xC2,0xD2,0xB9,0xC1,0xEE,0x97,0xCE,0x66,0xE9,0x8A,0xA4,0xBC,0xB1,0xFC,0xCB,0x3B,0x24,0x6E,0x5B,0x87,0x19,0x64,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x97,0x4C,0x18,0x22,0xEF,0x9F,0x34,0x59,0x97,0x4C,0x18,0x22,0xEF,0x9F,0x34,0x58,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x97,0x4C,0x18,0x22,0xEF,0x9F,0x34,0x59,0x97,0x4C,0x18,0x22,0xEF,0x9F,0x34,0x58,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}; 


void send_data()
    {
//     cout<<"Times="<<times<<ENDL;  
     times++; 
//    static int current_byte = 0;
    static int current_bit = 7;
    
    DT = (data_TX[j] >> current_bit) & 1;
    --current_bit;
    
    if(current_bit == -1){
        current_bit = 7;
        j++;
        bitcount=1;
//      cout<<"SENDING"<<ENDL;
        if(j>=sizeof(data_TX))
        {
            j=0;
            
       
//        while(true);
      }
    }
}





void write_bbram_sequence(void){
   
    adf.write(0x19);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
   
    adf.write(0x00);   
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
   
    adf.write(0x00);
    adf.write(0x33);
    adf.write(0x00);
    adf.write(0xF9);
   
    adf.write(0xC2);
    adf.write(0x10);
    adf.write(0xC0);   
    adf.write(0x00);
   
    adf.write(0x30);
    adf.write(0x31);
    adf.write(0x07);   
    adf.write(0x00);
       
    adf.write(0x01);
    adf.write(0x00);
    adf.write(0x7F);
    adf.write(0x00);
   
    adf.write(0x0B);
    adf.write(0x37);
    adf.write(0x00);   
    adf.write(0x00);
    adf.write(0x40);
    adf.write(0x0C);
    adf.write(0x00);
    adf.write(0x05);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x18);
    adf.write(0x12);
    adf.write(0x34);
    adf.write(0x56);
    adf.write(0x10);
    adf.write(0x10);
    adf.write(0x08);
    adf.write(0x14);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x04);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    
    }
   
    void initiate(void){
       
      //  CS=0;
//        adf.write(0xB0);
//        CS=1;
//        wait_ms(2);
       
        CS=0;
        adf.write(0x1B);
        adf.write(0xFA);
        adf.write(0xA0);
        CS=1;
        wait_ms(2);
       
        CS=0;
        adf.write(0x18);
        adf.write(0x0D);
        adf.write(0x00);
        CS=1;
        wait_ms(2);
        
        CS=0;
        adf.write(0xB0);
        CS=1;
        wait_ms(3);
        
         CS=0;
        adf.write(0xB0);
        CS=1;
        wait_ms(3);
        
        
        CS=0;
        write_bbram_sequence();
        CS=1;
        wait_ms(2);
       
        cout<<"BBRAM_SEQUENCE WRITTEN"<<ENDL;
       
       
        CS=0;
        adf.write(0xFF);
        adf.write(0xFF);
        CS=1;
        wait_ms(1);
       
       
        CS=0;
        adf.write(0xFF);
        adf.write(0xFF);
        CS=1;
        wait_ms(1);
       
              
        CS=0;
        adf.write(0xBB);//CONFIGURE_DEV
        CS=1;
        wait_ms(2);
       
        cout<<"CONFIG_DEV"<<ENDL;
       
        CS=0;
        adf.write(0xB1);//PHY_ON
        CS=1;
        wait_ms(2);
       
        CS=0;
        adf.write(0xB5);//PHY_TX
        CS=1;
        wait_ms(2);
        
        cout<<"PHY_TX"<<ENDL;
     }


         

int main(){
   
    
    CS = 1;
    adf.format(8,0);
    adf.frequency( 1000000 );
   
    cout << "Press s" << ENDL;
    ledr = 1;
    char c = 'a';
    while( c != 's'){
        c = PC.getc();
        PC.putc(c);
    }
    ledr = 0;
       
    initiate();
    cout << "initiated" << ENDL;
    int state;
    if(clk == 0){
        state = 0;
    }
    else{
        state = 1;
    }
    
    int l=0;
    while(l<=1000){
        cout << "transmitting" << ENDL;
//        cout<<bitcount<<ENDL;
        bitcount++;
        
        if(clk == 0){
            if(state == 1){
                state = 0;
                send_data();
            }
        }
        else{
            state = 1;
        }
        l++;
    }
    
    
    CS=0;    
    adf.write(0xB1);
    CS=1;
    wait(1);
    cout<<"Transmission should have stopped by now "<<ENDL;
}