#include "mbed.h"
#include <iostream>
using namespace std;
#include <bitset>

#define ENDL "\r" << endl;
#define START_ADDRESS 0x020;




//SPI
SPI adf(PTD6, PTD7, PTD5);
//MOSI, MISO, CLOCK

DigitalOut CS(D10);
Serial PC(USBTX, USBRX);
DigitalOut ledr(LED_RED);

#define SPI_NOP 0xFF
//I have made some changes in the code in wait,while and CS please use adf_rolling buffer
enum con_type{ packet=0x18, bbram=0x19, mcr=0x1B, program=0x1E };
enum discon_type{ packet2=0x08, bbram2=0x09, mcr2=0x0B };

enum discon_type_RD{ packet3=0x28, bbram3=0x29, mcr3=0x2B };

void write_con(con_type ram, uint8_t address, uint8_t *data, int length){
    
    int *response = new int[length];

    CS = 0;
    
//    ignore recevived data
    adf.write( ram );
    
//    write start address
    int r = adf.write( address );
    
//    write data
    for(int i = 0 ; i < length ; ++i){
        response[i] = adf.write( data[i] );
    }
    
    CS = 1;
    
    cout << r << ENDL;
    for(int i = 0 ; i < length ; ++i){
        cout << response[i] << " ";
    }
    cout << ENDL;
    
}

void write_discon(discon_type ram, uint8_t *address, uint8_t *data, int length){
    
    int *response1 = new int[length];
    int *response2 = new int[length];
    
    CS = 0;
    
//    ignore recevived data
    adf.write( ram );
        
    for(int i = 0 ; i < length ; ++i){

//    address[7:0] next 8 bits
        response1[i] = adf.write( address[i] );
        
//        data next 8 bits
        response2[i] = adf.write( data[i] );
        
    }

    CS = 1;
    
    for(int i = 0 ; i < length ; ++i){
        cout << response1[i] << "\t" << response2[i] << ENDL;
    }
    
}

void initiate_rolling_buffer(void){
    CS = 0;//TESTMODES REGISTER 09 39 data 
    adf.write(0x09);
    adf.write(0x39);
    adf.write(0x10);
    CS = 1;
    
    CS = 0;//Transmit length
    adf.write(0x08);
    adf.write(0x14);
    adf.write(0xFF);
    CS = 1;
    
    
    CS = 0;//transmit length
    adf.write(0x08);
    adf.write(0x15);
    adf.write(0xFF);
    CS = 1;
    
    CS = 0;//TX BASE ADDRESS 09 24 20
    adf.write(0x09);
    adf.write(0x24);
    adf.write(0x20);
    CS = 1;
    
    CS = 0;//BUFFER SIZE
    adf.write(0x09);
    adf.write(0x37);
    adf.write(0xE0);
    CS = 1;
      
    CS = 0;//BUFFER SIZE
    adf.write(0x09);
    adf.write(0x36);
    adf.write(0x70);
    CS = 1;
    
    CS = 0;//BUFFER SIZE
    adf.write(0x09);
    adf.write(0x36);
    adf.write(0x70);
    CS = 1;
    
    cout<<"Initiated"<<ENDL;
}

void transmit_rolling_buffer(void){
    
    CS = 0;
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    adf.write(0xFF);
    
    CS=1;
    
    CS=0;
    adf.write(0xB5);
    CS=1;
    wait_ms(2);
    
    cout<<"Transmitted"<<ENDL;
    }
    
int read_discon(discon_type_RD ram, uint8_t address){
    
    CS = 0;
    
//    ignore the reply
    adf.write( ram );
    
    int stat1 = adf.write( address );
    int stat2 = adf.write( SPI_NOP );
    int reply = adf.write( SPI_NOP );
    
    CS = 1;
    
    return reply;
}

int main(){
    
    CS = 1;
    adf.format(8,0);
    adf.frequency( 1000000 );
    
    cout << "Press s" << ENDL;
    ledr = 1;
    char c = 'a';
    while( c != 's'){
        c = PC.getc();
        PC.putc(c);
    }
    ledr = 0;
    int d=0;
    

//    while(true){
//        ledr = !ledr;
//        wait(0.2f);
//    }
    initiate_rolling_buffer();
    while(true){
        CS = 0;
        d++;
        cout<<d<<ENDL;
       // wait_us(1);
//       initiate_rolling_buffer();
       transmit_rolling_buffer();  
   // wait_us(1);
//    adf.write(0xB5);
  //  adf.write(0xB5);
//    d=0;
  //  wait_us(1);
//    CS = 1;
//    wait_ms(2);
//    CS=0;    
        unsigned char reply1 = adf.write(0xFF);
//        d=0;
        unsigned char reply2 = adf.write(0xFF);

        
        std::bitset<8> b = reply1;
        cout << b << " \t ";
        b = reply2;
        cout << b << " \t " << ENDL;
        

    }