#include "mbed.h"
#define ENDL "\r" << endl
#include<iostream>

using namespace std;
DigitalOut led(LED_RED);
DigitalOut CS(D10);
InterruptIn IRQ();

SPI adf(PTD6, PTD7, PTD5); // mosi, miso, sclk


void bbram_write()
{   
    CS=0;
    // To bring in off state
    adf.write(0xB0);
    wait_ms(2);
    CS=1;
    
    // Write bbram
    CS=0;
    adf.write(0x19);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    
    adf.write(0x00);    
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    
    adf.write(0x00);
    adf.write(0x33);
    adf.write(0x00);
    adf.write(0xF4);
    
    adf.write(0xC2);
    adf.write(0x10);
    adf.write(0xC0);    
    adf.write(0x00);
    
    adf.write(0x30);
    adf.write(0x31);
    adf.write(0x07);    
    adf.write(0x00);
        
    adf.write(0x01);
    adf.write(0x00);
    adf.write(0x7F);
    adf.write(0x00);
    
    adf.write(0x0B);
    adf.write(0x37);
    adf.write(0x00);    
    adf.write(0x00);
    
    adf.write(0x40);
    adf.write(0x0C);
    adf.write(0x00);
    adf.write(0x05);
    
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x18);
    adf.write(0x12);
    
    adf.write(0x34);
    adf.write(0x56);
    adf.write(0x10);
    adf.write(0x10);
    
    adf.write(0xC4); // Different
    adf.write(0x14);
    adf.write(0x00);
    adf.write(0x00);
    
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    
    adf.write(0x04);
    adf.write(0x00);
    adf.write(0x00);
    adf.write(0x00);
    
    adf.write(0x00);
    adf.write(0x00);
    CS=1;
    wait(1);
    
  //CMD_CONFIG_DEV  
    CS=0;
    adf.write(0xBB);
    CS=1;
    wait_ms(2);
    
    
}


void initiate_rolling_buffer(void){
    // Testmode register
    CS=0;
    adf.write(0x09);
    adf.write(0x39);
    adf.write(0x10);
    CS=1;
    wait_ms(2);
    
    //CMD_CONFIG_DEV
    CS=0;
    adf.write(0xBB);
    CS=1;
    wait_ms(2);
    
    //Status ReadBack
    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
    wait_ms(2);    
    
     // PHY_Off
    CS=0;
    adf.write(0xB0);
    CS=1;
    wait(0.1);
    CS=0;
    adf.write(0xFF);
    adf.write(0xFF);
    CS=1;
    wait(0.1);
    
    // TRANSMIT_DATA LENGTH
    CS=0;
    adf.write(0x08);
    adf.write(0x14);
    adf.write(0x05);//<--------Changed fromm FF to 05
    CS=1;
    wait_ms(2);
    CS=0;
    adf.write(0x08);
    adf.write(0x15);
    adf.write(0x40);//<------------Changed frok FF to 40
    CS=1;
    wait_ms(2);
    // TX_BASE ADDRESS
    CS=0;
    adf.write(0x09);
    adf.write(0x24);
    adf.write(0x20);
    CS=1;
    wait_ms(2);
    // BUFFER SIZE
    CS=0;
    adf.write(0x09);
    adf.write(0x37);
    adf.write(0xE0);
    CS=1;
    wait_ms(2);
    CS=0;
    adf.write(0x09);
    adf.write(0x36);
    adf.write(0x70);
    CS=1;
    wait_ms(2);
    }

void data_write()
{
    CS=0;
    adf.write(0xB1);
    CS=1;
    wait_ms(2);
    
    CS=0;
    adf.write(0xB5);
    CS=1;
    wait_ms(20);    
    
    
//    while(1)
//    {
//        pool_irq();
//        CS=0;
//         adf.write(0x2B);
//         adf.write(0x36);
//    int irq1 = adf.write(0xFF);
//    int irq2 = adf.write(0xFF);
//         CS=1;    
//         wait_us(500);
//         cout<<irq1<<"/t"<<irq2<<ENDL; 
//    }
    
}




int reply1 =0;//Temp
int reply2 =0;//TEMP
void temp_read_all(void){
    
    adf.write();
    adf.write();
    adf.write();
    adf.write();
    adf.write();
    adf.write();
    
    cout<<""<<reply1<<""<<reply2<<ENDL;
 
 
    adf.write();
    adf.write();
    adf.write();
    adf.write();
    adf.write();
    adf.write();
    
    cout<<""<<reply1<<""<<reply2<<ENDL;   
    }
void temp_read_irqsrc(void){
    
    adf.write();//Read 0x336
    status read1 = adf.write();
    status read2 = adf.write();
    irq336 = adf.write();
    adf.write();

    irq336 &=  0x60;
    
    if (irq336 == 0x40){
        
        tx_half();
        put_irq_zero();
        
        }
    else if (irq336 == 0x20){
        
        tx_full();
        put_irq_zero();
        
        }    
    else if (irq336 == 0x00){
        cout<<"error due to other interrupts"<<ENDL;
        put_irq_zero();
        }
    else
    cout<<"Bitwise and not working check your code"<<ENDL;
    }

void put_irq_zero(void){
    
    
    adf.write(0x0B);
    adf.write(0x36);
    adf.write(0x00);
    adf.write(0x37);
    adf.write(0x00);//incase not written write multiple times
//    temp_read_all();
    }

    


int main()
{
    adf.format(8,0);
    adf.frequency(1000000);
    bbram_write();
    data_write();
    while(true){
        cout<<"working"<<ENDL;
        IRQ.rise(&temp_read_irqsrc);
        
        }
        
        
        
        
    
    
    }
}