#include "mbed.h"
#include <iostream>
using namespace std;
#include <bitset>

#define ENDL "\r" << endl;
#define START_ADDRESS 0x020;

SPI adf(PTD6, PTD7, PTD5);
//MOSI, MISO, CLOCK

DigitalOut CS(D10);
Serial PC(USBTX, USBRX);
DigitalOut ledr(LED_RED);

#define SPI_NOP 0xFF

enum con_type{ packet=0x18, bbram=0x19, mcr=0x1B, program=0x1E };
enum discon_type{ packet2=0x08, bbram2=0x09, mcr2=0x0B };

enum discon_type_RD{ packet3=0x28, bbram3=0x29, mcr3=0x2B };

void write_con(con_type ram, uint8_t address, uint8_t *data, int length){
    
    int *response = new int[length];

    CS = 0;
    
//    ignore recevived data
    adf.write( ram );
    
//    write start address
    int r = adf.write( address );
    
//    write data
    for(int i = 0 ; i < length ; ++i){
        response[i] = adf.write( data[i] );
    }
    
    CS = 1;
    
    cout << r << ENDL;
    for(int i = 0 ; i < length ; ++i){
        cout << response[i] << " ";
    }
    cout << ENDL;
    
}

void write_discon(discon_type ram, uint8_t *address, uint8_t *data, int length){
    
    int *response1 = new int[length];
    int *response2 = new int[length];
    
    CS = 0;
    
//    ignore recevived data
    adf.write( ram );
        
    for(int i = 0 ; i < length ; ++i){

//    address[7:0] next 8 bits
        response1[i] = adf.write( address[i] );
        
//        data next 8 bits
        response2[i] = adf.write( data[i] );
        
    }

    CS = 1;
    
    for(int i = 0 ; i < length ; ++i){
        cout << response1[i] << "\t" << response2[i] << ENDL;
    }
    
}

int read_discon(discon_type_RD ram, uint8_t address){
    
    CS = 0;
    
//    ignore the reply
    adf.write( ram );
    
    int stat1 = adf.write( address );
    int stat2 = adf.write( SPI_NOP );
    int reply = adf.write( SPI_NOP );
    
    CS = 1;
    
    return reply;
}

int main(){
    
    CS = 1;
    adf.format(8,0);
    adf.frequency( 1000000 );
    
    cout << "Press s" << ENDL;
    ledr = 1;
    char c = 'a';
    while( c != 's'){
        c = PC.getc();
        PC.putc(c);
    }
    ledr = 0;
    int d=0;
    

//    while(true){
//        ledr = !ledr;
//        wait(0.2f);
//    }
    

    while(true){
        CS = 0;
       // wait_us(1);
         
   // wait_us(1);
    adf.write(0xB5);
  //  adf.write(0xB5);
//    d=0;
  //  wait_us(1);
    CS = 1;
    wait_ms(2);
    CS=0;    
        unsigned char reply1 = adf.write(0xFF);
//        d=0;
        unsigned char reply2 = adf.write(0xFF);
//        d=0;
//     wait_us(1);
//        unsigned char reply3 = adf.write(0xFF);
//        unsigned char reply4 = adf.write(0xFF);
        CS = 1;
        
          std::bitset<8> b = reply1;
          cout << b << " \t ";
          b = reply2;
          cout << b << " \t " << ENDL;
        
//        wait_ms(10);
    }
//        b = reply3;
//        cout << b << "\t";
//        b = reply4;
//        cout << b << ENDL;
    
//        wait_ms(330);
//        
//        CS = 0;
//        wait_us(10);
//        adf.write(0xff);
//        adf.write(0xff);
//        wait_us(10);
//        CS = 1;
        
//        cout << "SENT" << ENDL;
//        wait(1);
//        ledr = !ledr;
//    }
    
//    
////    BUFFER SIGNAL AND SIZE AND BASE ADDRESS
//    discon_type ram_type = bbram2;
//    uint8_t *add = new uint8_t[3];
//    add[0] = 0x36;
//    add[1] = 0x37;
//    add[2] = 0x24;
//    uint8_t *data = new uint8_t[3];
////    110
//    data[0] = 0x6E;
////    220
//    data[1] = 0xDC;
//    data[2] = START_ADDRESS;
//    
//    cout << "BUFFER SIGNAL AND SIZE AND BASE ADDRESS" << ENDL;
//    write_discon( ram_type, add, data, 3 );
//    wait(1);
//    
//    
////    TESTMODES
//    discon_type_RD ram_rd = bbram3;
//    cout << "READ 139" << ENDL;
//    int dat139 = read_discon( ram_rd, 0x39 );
//    wait(1);
//    cout << "dat139 = " << dat139 << ENDL;
//    dat139 |= (1 << 4);
//    dat139 &= ~(1 << 5);
//    
//    delete[] add;
//    delete[] data;
//    
//    add = new uint8_t[1];
//    data = new uint8_t[1];
//    add[0] = 0x39;
//    data[0] = dat139;
//    cout << "write testmode " << ENDL;
//    write_discon( ram_type, add, data, 1 );
//    wait(1);
//    
////    transmit size in bytes [268 = 0x010C] [220 = 0xDC]
//    ram_type = packet2;
//    delete[] add;
//    delete[] data;
//    add = new uint8_t[2];
//    data = new uint8_t[2];
//    add[0] = 0x14;
//    add[1] = 0x15;
//    data[0] = 0xDC;
//    data[1] = 0x00;
//    cout << "transmit size in packet ram" << ENDL;
//    write_discon( ram_type, add, data, 2 );
//    
////    START WRITING TO RAM HERE
//    con_type rt = packet;
//    delete[] data;
//    data = new uint8_t[220];
//        
//    for(int i = 0 ; i < 220 ; ++i){
//        data[i] = 0xff;
//    }
//    uint8_t haha = START_ADDRESS;
//    cout << "WRITE PAYLOAD " << ENDL;
//    write_con( rt, haha, data, 220 );
//    cout << "FINISHED" << ENDL;
//    wait(1);
//    
////    AND PUT INTO PHY_TX MODE
//    int reply = adf.write( 0xB5 );
//    cout << reply << ENDL;
//    
//    wait(5);
//    
//    reply = adf.write( 0xB1 );
//    cout << reply << ENDL;
//    
//    cout << "FINISHED !!" << ENDL;

}