#include "mbed.h"
#include "mbed_rpc.h"

/**
 *  This example program has been updated to use the RPC implementation in the new mbed libraries.
 *  This example shows the creation of the RPCDigitalOut wrapper class over the RPC interface
 */

//Use the RPC enabled wrapped class  - see RpcClasses.h for more info
RpcDigitalOut led1(LED1,"led1");
Serial pc(USBTX, USBRX);

int main() {
    //Allows RPC to create objects of type RPCDigitalOut via the RPC Interface
    RPC::add_rpc_class<RpcDigitalOut>();

    char buf[256], outbuf[256];
    while(1) {
        pc.gets(buf, 256);
        //Call the static call method on the RPC class
        RPC::call(buf, outbuf); 
        pc.printf("%s\n", outbuf);
    }
}