#include "mbed.h"
#include "mbed_rpc.h"

/**
 *  This example program has been updated to use the RPC implementation in the new mbed libraries.
 *  This example shows the uses of the RPCDigitalOut wrapper class
 */

//Use the RPC enabled wrapped class  - see RpcClasses.h for more info
RpcDigitalOut mbedled(LED1,"mbedled");
RpcDigitalIn     sw(p8, "switch");
RpcPwmOut       led(p21, "pwmled");
Serial pc(USBTX, USBRX);

int main() {

    char buf[256], outbuf[256];
    while(1) {
        pc.gets(buf, 256);
        //Call the static call method on the RPC class
        RPC::call(buf, outbuf); 
        pc.printf("%s\n", outbuf);
    }
}