#include "mbed.h"
#include "bodyPiece.h"
#include <list>
#include "ledCube.h"

#ifndef SNAKE_H
#define SNAKE_H

// Macros
#define START_DIRECTION Down
#define START_SPEED 10
// Zero indexed number of columns and rows
#define NUM_COLS 4
#define NUM_ROWS 4

typedef enum {
    Up,Down,Left,Right
} Direction;

class snake
{
public:

    // constructor
    snake(char startRow, char startCol);
    
    // public variables
    int movementSpeed; // Speed at which the snake is moving
    Direction movementDirection; // Direction in which the snake is moving
    int bodySize; // Size of the snake's body
    std::list<bodyPiece> snakeBody;
    
    // Function Prototypes
    char moveSnake(ledCube *cube); // Moves the snake by one in the direction of movementDirection
                      // Will return 1 if out of bounds or if the head has hit a bodyPiece, 0 if still in the boundaries
    void addPiece(); // Adds a bodyPiece to the tail
    bool isEating(char foodRow, char foodCol);

private:
    char move(char newHeadRow, char newHeadCol, ledCube *cube);
};

class food
{
public:
    char currRow, currCol;
    food(char row, char col);
    void moveFood(char row, char col);
};

#endif // SNAKE_H