#include "mbed.h"
#include "ledCube.h"
#include "ledValues.h"
#include "MCP23S17.h"

// Set up the ledArray output pins
ledCube::ledCube()
{
    spi = new SPI(p11, p12, p13);
    char Opcode = 0x40; // Used to start the spi communication with the DIP
    chip = new MCP23S17(*spi, p20, Opcode);

    ledArray[0][0] = new DigitalOut(P000);
    ledArray[0][1] = new DigitalOut(P001);
    ledArray[0][2] = new DigitalOut(P002);
    ledArray[0][3] = new DigitalOut(P003);
    ledArray[0][4] = new DigitalOut(P004);
    ledArray[1][0] = new DigitalOut(P010);
    ledArray[1][1] = new DigitalOut(P011);
    ledArray[1][2] = new DigitalOut(P012);
    ledArray[1][3] = NULL;
    ledArray[1][4] = NULL;
    ledArray[2][0] = NULL;
    ledArray[2][1] = NULL;
    ledArray[2][2] = NULL;
    ledArray[2][3] = NULL;
    ledArray[2][4] = NULL;
    ledArray[3][0] = NULL;
    ledArray[3][1] = new DigitalOut(P031);
    ledArray[3][2] = new DigitalOut(P032);
    ledArray[3][3] = new DigitalOut(P033);
    ledArray[3][4] = new DigitalOut(P034);
    ledArray[4][0] = new DigitalOut(P040);
    ledArray[4][1] = new DigitalOut(P041);
    ledArray[4][2] = new DigitalOut(P042);
    ledArray[4][3] = new DigitalOut(P043);
    ledArray[4][4] = new DigitalOut(P044);
    spiCurrentlyLit = 0;
    //  Set all 8 Port A bits to output direction
    (*chip).direction(PORT_A, 0x00);
    //  Set all 8 Port B bits to output direction
    (*chip).direction(PORT_B, 0x00);
    lastLedLit = NULL;
    (*chip).write(PORT_A, spiCurrentlyLit);
}
// Light the LED at the specified row, column, layer coordinate
void ledCube::turnOnLed(char row, char column, char layer)
{
    if(ledArray[row][column] != NULL){
        *ledArray[row][column] = 1;
    }
    // This else handles cases where the LEDs are handled by the I/O extender
    else{
    //printf("before on-spiCurrentlyLit: %d turn on Row: %d Col: %d \n", spiCurrentlyLit, row, column);
        if( row == 1 && column == 3){
            spiCurrentlyLit |= 0x01;   
        }
        else if(row == 1 && column == 4){
            spiCurrentlyLit |= 0x02;
        }
        else if(row == 2 && column == 0){
            spiCurrentlyLit |= 0x04;
        }
        else if(row == 2 && column == 1){
            spiCurrentlyLit |= 0x08;
        }
        else if(row == 2 && column == 2){
            spiCurrentlyLit |= 0x10;
        }
        else if(row == 2 && column == 3){
            spiCurrentlyLit |= 0x20;
        }
        else if(row == 2 && column == 4){
            spiCurrentlyLit |= 0x40;
        }
        else if(row == 3 && column == 0){
            spiCurrentlyLit |= 0x80;
        }
        (*chip).write(PORT_A, spiCurrentlyLit);
    }
}

// Turns off the LED at the specified row and column
void ledCube::turnOffLed(char row, char column, char layer)
{
    if(ledArray[row][column] != NULL){
        *ledArray[row][column] = 0;
    }
    // This else handles cases where the LEDs are handled by the I/O extender
    else{
        //printf("before: off-spiCurrentlyLit: %d turn off Row: %d Col: %d \n", spiCurrentlyLit, row, column);
        if( row == 1 && column == 3){
            spiCurrentlyLit &= ~(0x01);   
        }
        else if(row == 1 && column == 4){
            spiCurrentlyLit &= ~(0x02);
        }
        else if(row == 2 && column == 0){
            spiCurrentlyLit &= ~(0x04);
        }
        else if(row == 2 && column == 1){
            spiCurrentlyLit &= ~(0x08);
        }
        else if(row == 2 && column == 2){
            spiCurrentlyLit &= ~(0x10);
        }
        else if(row == 2 && column == 3){
            spiCurrentlyLit &= ~(0x20);
        }
        else if(row == 2 && column == 4){
            spiCurrentlyLit &= ~(0x40);
        }
        else if(row == 3 && column == 0){
            spiCurrentlyLit &= ~(0x80);
        }
        (*chip).write(PORT_A, spiCurrentlyLit);
    }
}

// Blinks all the LEDs to indicate losing
void ledCube::blink()
{
    for(char i = 0; i < 5; i++) {
        for(char j = 0; j < 5; j++) {
            turnOnLed(i,j,0);
        }
    }
        wait(.3);
    for(char i = 0; i < 5; i++) {
        for(char j = 0; j < 5; j++) {
            turnOffLed(i,j,0);
        }
    }
    wait(.3);
}
