#include "snake.h"
#include "bodyPiece.h"
#include <list>
#include "ledCube.h"

// Constructor
snake::snake(char startRow, char startCol)
{
    bodyPiece head = bodyPiece();
    head.currRow = startRow;
    head.currCol = startCol;
    snakeBody.push_back(head);
    bodySize = 1;
    movementDirection = START_DIRECTION;
    movementSpeed = START_SPEED;
}

// Movement method for the snake, will update LEDs and snake's body
char snake::move(char newHeadRow, char newHeadCol, ledCube *cube)
{

    // Variables to hold the bodyPiece's X and Y positions on the grid
    char prevRow, prevCol, tempRow, tempCol;

    // Store the snake's head into the iterator
    std::list<bodyPiece>::iterator it=snakeBody.begin();
    // Save the head's current Row and Col position
    prevRow = (*it).currRow;
    prevCol = (*it).currCol;
    // Update the head to the new Row and Col
    (*it).currRow = newHeadRow;
    (*it).currCol = newHeadCol;
    (*cube).turnOffLed(prevRow, prevCol, 0);
    (*cube).turnOnLed((*it).currRow, (*it).currCol, 0);
    char bodyCount = 1;
    // Check to see if we are at the tail with this while loop
    while(bodyCount < bodySize) {
        // Move to the next bodyPiece
        it++;
        bodyCount++;
        // Store the previous piece's location in the current piece
        tempRow = (*it).currRow;
        (*it).currRow = prevRow;
        tempCol = (*it).currCol;
        (*it).currCol = prevCol;
        prevRow = tempRow;
        prevCol = tempCol;
        // Check to see if the head has collided with this bodyPiece
        if(snakeBody.front().currRow == prevRow && snakeBody.front().currCol == prevCol) {
            return 1;
        }
        if(prevRow < 5 && prevCol < 5) {
            (*cube).turnOffLed(prevRow, prevCol, 0);
        }
        (*cube).turnOnLed((*it).currRow, (*it).currCol, 0);
    }
    return 0;
}

// Checks the current movement direction and decided where to move the snake head next
// Will return 1 if out of bounds or if the head has hit a bodyPiece, 0 if still in the boundaries
char snake::moveSnake(ledCube *cube)
{
    bodyPiece head = snakeBody.front();
    char ret = 0;
    switch(movementDirection) {
        case Down:
            if(head.currCol+1 > NUM_COLS) {
                ret =  1;
            } else {
                ret = move(head.currRow, head.currCol+1, cube);
            }
            break;
        case Up:
            if(head.currCol-1 < 0) {
                ret = 1;
            } else {
                ret = move(head.currRow, head.currCol-1, cube);
            }
            break;
        case Left:
            if(head.currRow-1 < 0) {
                ret = 1;
            } else {
                ret = move(head.currRow-1, head.currCol, cube);
            }
            break;
        case Right:
            if(head.currRow+1 > NUM_ROWS) {
                ret = 1;
            } else {
                ret = move(head.currRow+1, head.currCol, cube);
            }
    }
    return ret;
}

// Adds a new piece on to snake's tail
void snake::addPiece()
{
    bodyPiece b;
    snakeBody.push_back(b);
    bodySize++;
    printf("piece added + bodySize: %d\n", bodySize);
}

bool snake::isEating(char foodRow, char foodCol)
{
    if(snakeBody.front().currRow == foodRow && snakeBody.front().currCol == foodCol) {
        addPiece();
        return 1;
    } else {
        return 0;
    }
}

// Constructor for the food class
food::food(char row, char col)
{
    currRow = row;
    currCol = col;
}

// Moves food to a new row and column
void food::moveFood(char row, char col)
{
    currRow = row;
    currCol = col;
}

