/*
*   5x5 LED Snake Game
*   Author: Daniel Hamilton
*   ECE 4180 Lab 3
*
*/

#include "mbed.h"
#include "ledCube.h"
#include "snake.h"
#include "main.h"

snake mySnake(snakeStartRow,snakeStartCol); // Snake represents the coordinates making up the snake
food myFood(foodStartRow, foodStartCol); // food pellet the snake is trying to eat
ledCube cube;                           // Currently a square, but represents and controls the physical LEDs
AnalogIn joyVer(p19);                   // vertical analog joystick input pin
AnalogIn joyHor(p18);                   // Horizontal analog joystick input pin
DigitalIn select(p17);                  // Pushbutton on the joystick (currently unused)

int main()
{
    printf("Start\n");
    int snakeUpdateCounter = 0; // keeps track of when we should move Snake
    cube.turnOnLed(snakeStartRow, snakeStartCol, 0); // Starts the snake at Row 0 Col 0
    updateFoodLed();                                 // Lights up the food LED
    printf("Setup Complete\n");
    bool gameover = false;                           // Is set to true when the game is over and keeps the LEDs blinking

    while(1) {
        // Update snake position if we are greater than the set movement speed
        if(snakeUpdateCounter++ >= mySnake.movementSpeed) {
            snakeUpdateCounter = 0;
            if(mySnake.moveSnake(&cube) || gameover) {
                gameover = true;
                cube.blink();
            }
            // See if the snake is on the Food's LED
            if(checkForSnakeEating()) {
                myFood.moveFood(rand() % 5, rand() % 5);
                updateFoodLed();
            }
        }
        updateDirectionInput();
        wait(.1);
    }
    
}

// Return true if the snake is on a food, false otherwise
bool checkForSnakeEating()
{
    return mySnake.isEating(myFood.currRow, myFood.currCol);
}

// Update the food's loction
void updateFoodLed()
{
    cube.turnOnLed(myFood.currRow, myFood.currCol, 0);
    printf("FOOD: Row: %d Col: %d\n", myFood.currRow, myFood.currCol);
    if(mySnake.movementSpeed > 0){
        mySnake.movementSpeed--;
    }
}

// Updates the direction the snake is traveling based on the analog controller's input
void updateDirectionInput(){
   float verValue, horValue;
    int pushed;
    select.mode(PullUp);
        verValue = joyVer;
        horValue = joyHor;
        pushed = select;
        if(horValue < .4){
            mySnake.movementDirection = Left;
            //printf("Left\n");
        }
        else if(horValue > .6){
            mySnake.movementDirection = Right;
            //printf("Right\n");
        }
        if(verValue < .4){
            mySnake.movementDirection = Down;
            //printf("Down\n");
        }
        else if(verValue > .6){
            mySnake.movementDirection = Up;
            //printf("Up\n");
        }
}