#include "mbed.h"
#include "MCP23S17.h"

#ifndef LEDCUBE_H
#define LEDCUBE_H
/*
 Class to represent the LED cube as a whole. Can light and select LEDs
*/
class ledCube
{
public:
    DigitalOut *ledArray[5][5];
    SPI *spi;
    MCP23S17 *chip;
    int numRows, numCols;
    ledCube();
    void turnOnLed(char row, char column, char layer);
    void turnOffLed(char row, char column, char layer);
    void blink();
    unsigned char spiCurrentlyLit;

private:
    DigitalOut *lastLedLit;
};

#endif //LEDCUBE_H