#include "mbed.h"
#define u8 unsigned char
#define u16 unsigned int
#define ubyte unsigned char
#define ushort unsigned short int
#define bit unsigned char
typedef struct {
    unsigned int pos; // raw reading from sensor 14 bits
    long oticks;  // revolution counter
    unsigned int calibPos;  // 0 to 2pi, converted to 16 bits
    unsigned int offset; // initial reading on setup - relative zero position
} EncObj; 

class enc
{
public:
    //Connect over i2c
    enc(PinName mosi, PinName miso, PinName sck, PinName cs);
    //Destroy instance
    ~enc();
    unsigned int  ams_read();
    void update_pos();
    void set_offset(ushort zpos);
    unsigned int cal_state(); //Calibrated stat
    static ushort par(ushort value);
    ushort write_spi(ushort reg, u8 rw);
    ushort read_spi(ushort reg);
    EncObj enc_pos;
    
private:
    SPI m_spi;
    DigitalOut csl;

};





