#include "mbed.h"
#include "enc.h"

Ticker RTI;
DigitalOut myled(LED1);
Serial pc(USBTX, USBRX); // tx, rx
enc crankPos(p5,p6,p7,p8);


void get_state(){
    crankPos.update_pos();
}

int main() {    
    RTI.attach(&get_state, 0.01);
    while(1) {
        myled = 1;
        wait(0.05);
        pc.printf("Encoder: %u                             \r\n", crankPos.cal_state());
        myled = 0;
        wait(0.05);
    }
}
