/* mbed Microcontroller Library - SDFileSystem
 * Copyright (c) 2008-2009, sford
 */
 
// VERY DRAFT CODE!!! 

#ifndef SDFILESYSTEM_H
#define SDFILESYSTEM_H

#include "mbed.h"
#include "FATFileSystem.h"

/* Class: SDFileSystem
 *  Access the filesystem on an SD Card using SPI
 *
 * Example:
 * > SDFileSystem sd(p5, p6, p7, p12, "sd");
 * > 
 * > int main() {
 * >     FILE *fp = fopen("/sd/myfile.txt", "w");
 * >     fprintf(fp, "Hello World!\n");
 * >     fclose(fp);
 * > }
 */
class SDFileSystem : public FATFileSystem {
public:

    /* Constructor: SDFileSystem
     *  Create the File System for accessing an SD Card using SPI
     *
     * Variables:
     *  mosi - SPI mosi pin connected to SD Card
     *  miso - SPI miso pin conencted to SD Card
     *  sclk - SPI sclk pin connected to SD Card
     *  cs   - DigitalOut pin used as SD Card chip select
   *  name - The name used to access the filesystem
     */
    SDFileSystem(PinName mosi, PinName miso, PinName sclk, PinName cs, const char* name);
    virtual int disk_initialize();
    virtual int disk_write(const char *buffer, int block_number);
    virtual int disk_read(char *buffer, int block_number);    
    virtual int disk_status();
    virtual int disk_sync();
    virtual int disk_sectors();

protected:

    int _cmd(int cmd, int arg);
    int _cmdx(int cmd, int arg);
    int _cmd41();
    int _cmd8();
    int _cmd58();
    int initialise_card();
    int initialise_card_v1();
    int initialise_card_v2();
    
    
    int _read(char *buffer, int length);
    int _write(const char *buffer, int length);
    int _sd_sectors();
    int _sectors;
    
    SPI _spi;
    DigitalOut _cs; 
    
    struct CSD_REGISTER  {
     unsigned reserved1:4;
     unsigned reserved2:3;
     unsigned low_voltage:1;
     unsigned reserved3:7;
     unsigned volt_27_28:1;
     unsigned volt_28_29:1;
     unsigned volt_29_30:1;
     unsigned volt_30_31:1;
     unsigned volt_31_32:1;
     unsigned volt_32_33:1;
     unsigned volt_33_34:1;
     unsigned volt_34_35:1;
     unsigned volt_35_36:1;
     unsigned reserved:6;
     unsigned card_capacity_status:1;
     unsigned card_power_up_status:1;
    };    
};

#endif
