#ifndef HISTORY_H
#define HISTORY_H

template<uint32_t BufferSize>
class History {
public:
    History() : _head(0),_read(0) {
        for(int i=0; i<BufferSize; i++)
            _pool[i] = 0;
    }

    ~History() {
    }
    
    uint64_t getToken() {
        uint64_t tok = _pool[_read++];
        _read %= BufferSize;
        return tok;
    }

    void save(const uint64_t& data) {
        _pool[_head++] = data;
        _head %= BufferSize;
    }

    bool exist(const uint64_t& data) {
        for(uint32_t i=0; i<BufferSize; i++) {
            DBG("%llu == %llu\r\n", _pool[i], data);
            if(_pool[i]==data) {
                return true;
            }
        }
        return false;
    }
    
    uint64_t last() {
        uint32_t prev = (_head-1+BufferSize)%BufferSize;
        return _pool[prev];
    }
    
    uint32_t last_ts() {
        return (uint32_t) last();
    }

    /** Reset the buffer
     *
     */
    void reset() {
        _head = 0;
        _read = 0;
    }

private:
    uint64_t _pool[BufferSize];
    volatile uint32_t _head, _read;
};


#endif