#include "mbed.h"
#include "hcsr04.h"

hcsr04 hcsr04a(p15, p16);
hcsr04 hcsr04b(p15, p17);

Serial pc(USBTX, USBRX); // tx, rx

int main() {
    pc.printf("Starting measurement readings.");
    while(1) {
        hcsr04a.trigger();                  // start trigger signal
        
        wait_ms(250);                        // wait at least 50 ms before triggering. 
        pc.printf("%f\t%f\t%f\t%f\r\n",hcsr04a.inches(), hcsr04a.cm(), hcsr04b.inches(), hcsr04b.cm());
    }
}