#include "mbed.h"
#include "USBMouse.h"
#include "MMA8451Q.h"
#include "TSISensor.h"
#include "WakeUp.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

USBMouse raton;
DigitalOut myled(LED2);
InterruptIn boton(PTD4);

bool dormido = false;

void dormir() {
    dormido = !dormido;
    myled = !myled;
}

int main()
{
    //TSISensor tsi;
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    AnalogIn   potx(A0);
    AnalogIn   poty(A1);
    boton.rise(&dormir);
    
    float velx = 0;
    float vely = 0;
    
    float x = 0;
    
    while (1) {
        if(dormido) {
            sleep();
        } else {
            x = -10*acc.getAccY();
            
            velx = potx*20 - 16;
            vely = poty*20 - 15;
            
            raton.move(velx, vely);
            
            if (x>5)
                raton.press(MOUSE_LEFT);
            else
                raton.release(MOUSE_LEFT);
            if(x<-5)
                raton.press(MOUSE_RIGHT);
            else
                raton.release(MOUSE_RIGHT);
        }  
    }
}
