#include "mbed.h"
#include "HTTPClient.h"
#include "ESP8266Interface.h"
#include "TCPSocketConnection.h"
#include "Websocket.h"
#include <string>

ESP8266Interface wifi(PC_10, PC_11, PC_13,9600); // TX,RX,Reset,Baud
Serial pc(USBTX, USBRX); // tx, rx
HTTPClient http;

const char* ssid = "IskonWLAN";
const char* pwd = "AB123456CD";
char str[512];

int main()
{
    pc.baud(9600);
    
    pc.printf("\r\nIntializing hardware...\r\n");
    if(wifi.init()) {
        pc.printf("Hardware intialized!\r\n");
        pc.printf("\nTrying to connect to WiFi: %s...\r\n", ssid);
        
        if(wifi.connect(ssid,pwd)) {
            pc.printf("WiFi: %s is connected!\r\n", ssid);
            
            if(wifi.is_connected()) {
                pc.printf("IP Adress: %s\r\n",wifi.getIPAddress());
            }
            else {
                pc.printf("No IP adress -> sonething went wrong with connection -> not connected \r\n");
            }
        } 
        else {
            pc.printf("Conenction fail!\r\n");
        }
    } 
    else {
        pc.printf("Hardware not intialized!\r\n");
    }
    
    wait(1);
    
    
    //GET
//    pc.printf("\nTrying to fetch page using GET...\n\r");
//    int ret = http.get("http://54.175.222.246/get", str, 512);//IP address is httpbin.org/get
//    if (!ret) {
//        pc.printf("Page fetched successfully - read %d characters\n\r", strlen(str));
//        pc.printf("Result: %s\n\r", str);
//    } else {
//        pc.printf("Error - ret = %d - HTTP return code = %d\n\r", ret, http.getHTTPResponseCode());
//    }
    
    
    
    //POST
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("\nTrying to POST data to httpbin.org/post...\n\r");
    int ret = http.post("http://88.99.30.27/~slimelhr/TestPOST/post.php", map, &inText);//IP address is httpbin.org/post
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n\r", strlen(str));
      printf("Result: %s\n\r", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n\r", ret, http.getHTTPResponseCode());
    }
}