	 / _____)             _              | |    
	( (____  _____ ____ _| |_ _____  ____| |__  
	 \____ \| ___ |    (_   _) ___ |/ ___)  _ \ 
	 _____) ) ____| | | || |_| ____( (___| | | |
	(______/|_____)_|_|_| \__)_____)\____)_| |_|
	  (C)2013 Semtech-Cycleo

Lora network packet forwarder project
======================================

## 1. Core program: lora_pkt_fwd
--------------------------------

The packet forwarder is a program running on the host of a LoRa Picocell gateway
that forwards RF packets receive by the concentrator to a server through a IP/UDP
link, and emits RF packets that are sent by the server.

	((( Y )))
	    |
	    |
	+- -|- - - - - - - - - - - - -+        xxxxxxxxxxxx          +--------+
	|+--+-----------+     +------+|       xx x  x     xxx        |        |
	||              |     |      ||      xx  Internet  xx        |        |
	|| Concentrator |<----+ Host |<------xx     or    xx-------->|        |
	||              | USB |      ||      xx  Intranet  xx        | Server |
	|+--------------+     +------+|       xxxx   x   xxxx        |        |
	|                             |           xxxxxxxx           |        |
	|                             |                              |        |
	|            Gateway          |                              +--------+
	+- - - - - - - - - - - - - - -+

Uplink: radio packets received by the gateway, with metadata added by the
gateway, forwarded to the server. Might also include gateway status.

Downlink: packets generated by the server, with additional metadata, to be
transmitted by the gateway on the radio channel. Might also include
configuration data for the gateway.

## 2. Helper programs
---------------------

Those programs are included in the project to provide examples on how to 
communicate with the packet forwarder, and to help the system builder use it 
without having to implement a full Lora network server.

### 2.1. util_sink ###

The packet sink is a simple helper program listening on a single port for UDP 
datagrams, and displaying a message each time one is received. The content of 
the datagram itself is ignored.

### 2.2. util_ack ###

The packet acknowledger is a simple helper program listening on a single UDP 
port and responding to PUSH_DATA datagrams with PUSH_ACK, and to PULL_DATA 
datagrams with PULL_ACK.

### 2.3. util_tx_test ###

The network packet sender is a simple helper program used to send packets 
through the gateway-to-server downlink route.

## 3. Helper scripts
--------------------

### 3.1. packet_forwarder/lora_pkt_fwd/update_gwid.sh

This script allows automatic update of Gateway_ID with unique MCU ID, in
packet forwarder JSON configuration file.

note: the util_chip_id procided with picoGW_hal repository needs to be compiled
and located in the same directory as this script.

## 4. User Guide
----------------

[A detailed PicoCell GW user guide is available here](http://www.semtech.com/images/datasheet/picocell_gateway_user_guide.pdf)

## 5. Changelog
---------------

### v0.1.0 - 2017-05-03 ###

* Updated lora_pkt_fwd for lgw_connect API change. A new command line option
is available to specify the COM device to be used to access the PicoCell board.

### v0.0.1 - 2017-04-07 ###

* Initial release of the packet forwarder , protocol specifications and helper
programs for Picocell Gateway, based on the packet forwarder of the Gateway
v1.0/v1.5.

## 6. Legal notice
------------------

The information presented in this project documentation does not form part of 
any quotation or contract, is believed to be accurate and reliable and may be 
changed without notice. No liability will be accepted by the publisher for any 
consequence of its use. Publication thereof does not convey nor imply any 
license under patent or other industrial or intellectual property rights. 
Semtech assumes no responsibility or liability whatsoever for any failure or 
unexpected operation resulting from misuse, neglect improper installation, 
repair or improper handling or unusual physical or electrical stress 
including, but not limited to, exposure to parameters beyond the specified 
maximum ratings or operation outside the specified range. 

SEMTECH PRODUCTS ARE NOT DESIGNED, INTENDED, AUTHORIZED OR WARRANTED TO BE 
SUITABLE FOR USE IN LIFE-SUPPORT APPLICATIONS, DEVICES OR SYSTEMS OR OTHER 
CRITICAL APPLICATIONS. INCLUSION OF SEMTECH PRODUCTS IN SUCH APPLICATIONS IS 
UNDERSTOOD TO BE UNDERTAKEN SOLELY AT THE CUSTOMERS OWN RISK. Should a 
customer purchase or use Semtech products for any such unauthorized 
application, the customer shall indemnify and hold Semtech and its officers, 
employees, subsidiaries, affiliates, and distributors harmless against all 
claims, costs damages and attorney fees which could arise.

*EOF*
