	 / _____)             _              | |    
	( (____  _____ ____ _| |_ _____  ____| |__  
	 \____ \| ___ |    (_   _) ___ |/ ___)  _ \ 
	 _____) ) ____| | | || |_| ____( (___| | | |
	(______/|_____)_|_|_| \__)_____)\____)_| |_|
	  (C)2013 Semtech-Cycleo

LoRa packet logger
===================

1. Introduction
----------------

This software is used to set up a LoRa concentrator using a JSON configuration
file and then record all the packets received in a log file, indefinitely, until
the user stops the application.
No filtering is done and all packets that are LoRa packets with the correct RF
parameters (frequency, datarate, bandwidth) should appear in the log.

2. Dependencies
----------------

This program uses the Parson library (http://kgabis.github.com/parson/) by
Krzysztof Gabis for JSON parsing.
Many thanks to him for that very practical and well written library.

This program is a typical example of LoRa concentrator HAL usage for receiving
packets.

Only high-level functions are used (the ones contained in loragw_hal) so there
is no hardware dependencies assuming the HAL is matched with the proper version
of the hardware.
Data structures of the received packets are accessed by name (ie. not at a
binary level) so new functionalities can be added to the API without affecting
that program at all.

It was tested with v1.3.0 of the libloragw library, and should be compatible
with any later version of the library assuming the API is downward-compatible.

3. Usage
---------

To stop the application, press Ctrl+C.

The only optional parameter when launching the application is the log rotation
time (in seconds).

The way the program takes configuration files into account is the following:
 * if there is a debug_conf.json parse it, others are ignored
 * if there is a global_conf.json parse it and look for the next file
 * if there is a local_conf.json parse it
If some parameters are defined in both global and local configuration files, the
local definition overwrites the global definition.

The global configuration file should be exactly the same throughout your
network, contain all global parameters (parameters for "sensor" radio channels)
and preferably default "safe" values for parameters that are specific for each
gateway (eg. specify a default MAC address).

If you have build the libloragw library for a specific radio band (eg. ETSI
868 MHz band) a ready-to-use global_conf.json file is generated by the Makefile 
with a set of channels typical for a 'LoRa MAC' network application.
If you don't specify a radio band, an empty global_conf.json is generated and
must be filled with the settings you need.

The local configuration file should contain parameters that are specific to each
gateway (eg. MAC address, frequency for backhaul radio channels).

In each configuration file, the program looks for a JSON object named
"SX1301_conf" that should contain the parameters for the LoRa concentrator board
(RF channels definition, modem parameters, etc) and another JSON object called
"gateway_conf" that should contain the gateway parameters (gateway MAC address,
IP address of the LoRa MAC controller, network authentication parameters, etc).

To learn more about the JSON configuration format, read the provided JSON files
and the API documentation. A dedicated document will be available later on.

The received packets are put in a CSV file whose name include the MAC address of
the gateway in hexadecimal format and a UTC timestamp of log starting time in
ISO 8601 recommended compact format:
yyyymmddThhmmssZ (eg. 20131009T172345Z for October 9th, 2013 at 5:23:45PM UTC)

To able continuous monitoring, the current log file is closed is closed and a
new one is opened every hour (by default, rotation interval is settable by the
user using -r command line option).
No packet is lost during that rotation of log file.
Every log file but the current one can then be modified, uploaded and/or deleted
without any consequence for the program execution.

4. License
-----------

Copyright (c) 2013, SEMTECH S.A.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.
* Neither the name of the Semtech corporation nor the
  names of its contributors may be used to endorse or promote products
  derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL SEMTECH S.A. BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

5. License for Parson library
------------------------------

Parson ( http://kgabis.github.com/parson/ )
Copyright (c) 2012 Krzysztof Gabis

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

*EOF*