	 / _____)             _              | |    
	( (____  _____ ____ _| |_ _____  ____| |__  
	 \____ \| ___ |    (_   _) ___ |/ ___)  _ \ 
	 _____) ) ____| | | || |_| ____( (___| | | |
	(______/|_____)_|_|_| \__)_____)\____)_| |_|
	  (C)2013 Semtech-Cycleo

LoRa concentrator SPI stress test
==================================

1. Introduction
----------------

This software is used to check the reliability of the link between the host
platform (on which the program is run) and the LoRa concentrator register file
that is the interface through which all interaction with the LoRa concentrator
happens.

2. Dependencies
----------------

This program only access the LoRa concentrator HAL library through its
loragw_reg "named registers" access sub-module.



The registers used are:
 * LGW_VERSION
 * LGW_IMPLICIT_PAYLOAD_LENGHT
 * LGW_FSK_REF_PATTERN_LSB
 * LGW_RX_DATA_BUF_ADDR
 * LGW_RX_DATA_BUF_DATA

A data buffer accessible through the 2 registers above must be implemented.

3. Usage
---------

The tests run forever or until an error is detected.
Press Ctrl+C to stop the application.

When an error is detected, diagnosis information are displayed. Please refer to
the source code for more details on what is displayed for diagnosis.

All tests use pseudo-random data generated by the rand() function. The random
generator is not seeded, and the same sequence of data will be use each time the
program is launched.

Basically, some random data is written, read back and then compared to the
initial written data. Some "useless" read on others registers might be inserted
to be sure that the data read back is coming from the hardware, and not from the
internal buffer(s) of the software driver(s).

Test 1 > R/W on a simple 8-bit register

Test 2 > R/W on a simple 8-bit register with interstitial reads on VERSION

Test 3 > R/W on a 32-bit register 

Test 4 > data buffer R/W 

4. License
-----------

Copyright (c) 2013, SEMTECH S.A.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in the
  documentation and/or other materials provided with the distribution.
* Neither the name of the Semtech corporation nor the
  names of its contributors may be used to endorse or promote products
  derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL SEMTECH S.A. BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*EOF*