/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: End device comissioning and comunication parameters

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#include "board.h"

//********************************************************************* COMISSIONING PARAMETERS ************************************************************************

#ifndef __LORA_COMISSIONING_H__
#define __LORA_COMISSIONING_H__

/*!
 * When set to 1 the application uses the Over-the-Air activation procedure
 * When set to 0 the application uses the Personalization activation procedure
 */
#define OVER_THE_AIR_ACTIVATION                     1

/*!
 * Indicates if the end-device is to be connected to a private or public network
 */
#define LORAWAN_PUBLIC_NETWORK                      true

#if( OVER_THE_AIR_ACTIVATION != 0 )

/*!
 * Mote device IEEE OUI (big endian)
 * \remark This is unique to a company or organization
 */
#define IEEE_OUI                                    0x4f, 0x72, 0x62

/*!
 * Mote device IEEE EUI (big endian)
 *
 * \remark In this application, if the last 4 bytes are all 0, then the 32 bit address is automatically generated using a pseudo random generator seeded with a value derived from BoardUniqueId value
 * If provided by user, e.g. {IEEE_OUI, 0x00, 0x00, 0x00, 0xFF, 0x01}, then this value is used by the application. *0x69, 0x00, 0xab, 0xcd, 0xaa 
 */
#define LORAWAN_DEVICE_EUI                          { IEEE_OUI, 0x69, 0x00, 0xab, 0xcd, 0xff } 

/*!
 * Application IEEE EUI (big endian)
 */
#define LORAWAN_APPLICATION_EUI                     { 0x70, 0xb3, 0xd5, 0x7e, 0xd0, 0x00, 0x96, 0x4b} //0x70, 0xb3, 0xd5, 0x7e, 0xd0, 0x00, 0x96, 0x4b     for TTN server
                                                                                                       //0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00     for semtech NA server
/*!
 * AES encryption/decryption cipher application key
 */
#define LORAWAN_APPLICATION_KEY                     { 0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff }

#else

/*!
 * Device address on the network (big endian)
 *
 * \remark In this application, if the value is 0, then the address is automatically generated using a pseudo random generator seeded with a value derived from BoardUniqueId value
 * If provided by user, e.g. 0x78563412, then this value is used by the application
 */
#define LORAWAN_DEVICE_ADDRESS                      ( uint32_t )0x0

/*!
 * AES encryption/decryption cipher network session key
 */
#define LORAWAN_NWKSKEY                             { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C }

/*!
 * AES encryption/decryption cipher application session key
 */
#define LORAWAN_APPSKEY                             { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C }

#endif

#endif // __LORA_COMISSIONING_H__

 
//********************************************************************* COMUNICATION PARAMETERS ************************************************************************

#ifndef __LORA_CONFIG_H__
#define __LORA_CONFIG_H__

/*!
 * Configure End-Device to use 8-channels corresponding to Block A
 * Comment/Uncomment to disable/enable Hybrid mode
 */
#define USE_BAND_915_HYBRID

#ifndef USE_BAND_915_HYBRID
/*!
 * Configure End-Device to use 64-channels across to Block A thru Block H
 */
#define USE_BAND_915

#else

// define channel block: e.g. USE_BAND_915_HYBRID_BLOCK_A, USE_BAND_915_HYBRID_BLOCK_B ... USE_BAND_915_HYBRID_BLOCK_H etc.
#define USE_BAND_915_HYBRID_BLOCK_A

#endif

/*!
 * Join requests trials periodicity(+12s). It is the time between RX1/RX2 and next TX
 */
#define OVER_THE_AIR_ACTIVATION_DUTYCYCLE           5000000  // value in us

/*!
 * Defines the application data transmission periodicity. It is the time between RX1/RX2 and next TX
 */
#define APP_TX_DUTYCYCLE                            25000000  // value in us

/*!
 * Defines the randomness in the dutycycle. 
 */
#define APP_TX_DUTYCYCLE_RND                        3000000

/*!
 * LoRaWAN confirmed messages
 * \remark 1 : Confirmed messages enabled. Must receive ACK from network server
           0 : Confirmed messages disabled. 
 */
#define LORAWAN_CONFIRMED_MSG_ON                    0

/*!
 * LoRaWAN Adaptive Data Rate
 *
 * \remark Please note that when ADR is enabled the end-device uses default datarate of DR_0
 */
#define LORAWAN_ADR_ON                              0

/*!
 * Default mote datarate
 * \remark DR_0 : 980 bps; DR_1 : 1760 bps; DR_2 : 3125 bps; DR_3 : 5470 bps; DR_4 : 12500 bps
 */
#define LORAWAN_DEFAULT_DATARATE                    DR_0

/*!
 * LoRaWAN application port
 */
#define LORAWAN_APP_PORT                            5

/*!
 * LoRaWAN User defined Tx Power
 *
 * \remark The Tx power level is set as TX_POWER_P_DBM, where 10 <= P <= 30 and P is even value { i.e. P = 10, 12, 14 ... 28 or 30 }
 */
#define LORAWAN_TX_POWER                            TX_POWER_10_DBM


#define LORAWAN_APP_DATA_SIZE                       11

/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/

#define USE_IKS01A1_SENSOR

#endif //  __LORA_CONFIG_H__

