#include "mbed.h"
#include "MODSERIAL.h"
#include <cstdlib>
#include <cmath>

#define byte char

#define ScreenWidth 12
#define ScreenHeight 11
#define DownSample 1

extern "C" void mbed_reset();

bool drawReadyFlag = false;
int bytes_received = 0;

typedef struct {
    byte blue;
    byte green;
    byte red;
} color;

byte ScreenBuf[ScreenWidth*ScreenHeight*3];

MODSERIAL pc(USBTX, USBRX, 1024, 2048);
DigitalOut led(LED1);

SPI spi(p5, NC, p7); // mosi, miso, sclk

void writePixel(int x, int y) {
    spi.write(ScreenBuf[(y*ScreenWidth+x)*3+2]);
    spi.write(ScreenBuf[(y*ScreenWidth+x)*3+1]);
    spi.write(ScreenBuf[(y*ScreenWidth+x)*3]);
}

void updateDisplay() {
    for (int x = ScreenWidth - 1; x >= 0; x--) {
        if (x % 2 == 0) {
            for (int y = 0; y < ScreenHeight; y++)
                writePixel(x, y);
        } else {
            for (int y = ScreenHeight - 1; y >= 0; y--)
                writePixel(x, y);
        }
    }
    wait_us(800);
}

int main() {
    pc.format(8,Serial::None,1);
    pc.baud(921600);
    spi.format(8,1);
    spi.frequency(1000000);
    
    while(1) {
        while(pc.readable()) {
            ScreenBuf[bytes_received] = pc.getc();
            bytes_received++;
            if (bytes_received == ScreenWidth * ScreenHeight * 3) {
                bytes_received = 0;
                drawReadyFlag = true;
                break;
            }
        }
        if (drawReadyFlag) {
            //pc.printf("updating display\r\n");
            updateDisplay();
            drawReadyFlag = false;
        }
    }
}