#ifndef ECHO_SERVER_H
#define ECHO_SERVER_H

#include "mbed.h"
#include "TCPSocket.h"
#include "UDPSocket.h"

#include "TCPEchoHandler.h"

/*
    Class: EchoServer
    Binds itself to port 7 on TCP and UDP and listens for
    incoming connections
*/
class EchoServer {
public:
    // Constructor: EchoServer
    // Creates the TCP and UDP sockets and wires up
    // the event callback methods
    EchoServer(char*);
    // Destructor: ~EchoServer
    // Deletes the TCP and UDP sockets
    ~EchoServer();
    /*
        Function: bind
        Binds the sockets to the specified ports
        Parameters:
            tcpPort - The TCP port to bind to (default 7 as per RFC862)
            udpPort - The UDP port to bind to (default 7 as per RFC862)
     */
    void bind(int tcpPort=7, int udpPort=7);
private:
    // Variable: tcpSock
    // The TCP server socket
    TCPSocket* tcpSock;
    // Variable: udpSock
    // The UDP socket
    UDPSocket* udpSock;
    
    // Function: onNetTcpSocketEvent
    // The callback function called by the network stack whenever an
    // event occurs on the TCP socket
    // Parameter: e - The event that has occurred
    void onNetTcpSocketEvent(TCPSocketEvent e);
    // Function: onNetUdpSocketEvent
    // The callback function called by the network stack whenever an
    // event occurs on the UDP socket
    // Parameter: e - The event that has occurred
    void onNetUdpSocketEvent(UDPSocketEvent e);
};

#endif
