#include"mbed.h"

#define ADXL345_I2C_READ        0xA7
#define ADXL345_I2C_WRITE       0xA6
#define ADXL345_I2C_ADDRESS     0x53
#define ADXL345_DEVID_REG       0x00
#define ADXL345_DATAX0_REG      0x32
#define ADXL345_POWER_CTL_REG   0x2D
#define MeasurementMode         0x08

I2C adxl345(PA_10,PA_09);
Serial uart0(PA_13,PA_14);
//DigitalOut led(LED1);
int16_t xyz[3] = {0, 0, 0};

int main() {
    char config[2];
    char data[6];
    config[0] = ADXL345_DEVID_REG;
    char output;
    uart0.baud(9600);
    adxl345.write( ADXL345_I2C_WRITE , config, 1);
    adxl345.read( ADXL345_I2C_READ , &output, 1);
    uart0.printf("ADXL345 device id is 0x%x.\r\n",output);
    config[0] = ADXL345_POWER_CTL_REG;
    config[1] = MeasurementMode;
    adxl345.write( ADXL345_I2C_WRITE, config, 2); //set power

    config[0]=ADXL345_DATAX0_REG;
    while (1)
    {
        adxl345.write( ADXL345_I2C_WRITE, config, 1);
        adxl345.read( ADXL345_I2C_READ , data, 6);
        xyz[0]=(int)data[1]<<8|(int)data[0];
        xyz[1]=(int)data[3]<<8|(int)data[2];
        xyz[2]=(int)data[5]<<8|(int)data[4];
        uart0.printf("%6i, %6i, %6i\n", xyz[0], xyz[1], xyz[2]);
        wait(0.1);
    }
}