#include "mbed.h"
 
Serial uart0(PA_13, PA_14); // tx, rx
Serial uart2(PC_10, PC_11); // tx, rx
DigitalOut myD1(D10);
DigitalOut myD2(D11);
DigitalOut myD3(D12);
DigitalOut myD4(D2);
AnalogIn myA1(A1);
AnalogIn myA2(A2);
AnalogIn myA3(A3);
PwmOut PWM1(D3);
PwmOut PWM2(D5);
PwmOut PWM3(D6);
DigitalIn myButton(PC_06);
 
Timeout digitalTimeout;
Timeout analogTimeout; 
void attimeoutD()
{
    static int pos = 0;
    if(pos == 0){
        myD1 = 0;
        myD2 = 0;
        myD3 = 0;
        myD4 = 0; 
    }else{
        myD1 = 1;
        myD2 = 1;
        myD3 = 1;
        myD4 = 1;
    }
    pos = !pos;
    digitalTimeout.attach(&attimeoutD,0.5);
}
void attimeoutA()
{
    uart0.printf("A1:%02fV  ",myA1.read()*3.3);
    uart0.printf("A2:%02fV  ",myA2.read()*3.3);
    uart0.printf("A3:%02fV  \r\n",myA3.read()*3.3);
    analogTimeout.attach(&attimeoutA,1); 
}
 
int main() {
    uart0.baud(9600);
    uart2.baud(9600);   
    PWM1.period_us(500);
    PWM2.period_us(500);
    PWM3.period_us(500);
    PWM1 = 0.2;
    PWM2 = 0.5; 
    PWM3 = 0.8;
    uart2.printf("uart2:for Loopback test,please input something\n");
    uart0.printf("start testing digitalOut and PWM and analogIn\r\n");
    digitalTimeout.attach(&attimeoutD,0.5);
    analogTimeout.attach(&attimeoutA,1);
    
    while(1) {
        if (myButton == 0) { 
          uart0.printf("User Button is Pressed!!!\r\n");
        }
        if(uart2.readable()){
          char ch = uart2.getc();
          uart2.printf("%c", ch);
        }
    }
}