//=================================================================
// The main program file.
//
// Copyright 2022 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.
//==================================================================

// External libs
#include <stdlib.h>

// Project includes
#include "globals.h"
#include "hardware.h"
#include "graphics.h"
#include "keyboard.h"


//some LED's to use for debugging.
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

void set_random_seed();


/*
* This function handles the main logic of the game. You should
* initialize the hardware in this function, make calls to 
* functions that update the keyboard and your guess of 
* the word. 
*/
int main()
{ 
    // First things first: initialize hardware
    ASSERT_P(hardware_init() == ERROR_NONE, "Hardware init failed!");
    pc.printf("Program Starting\n");
    //led1 hardware initialization
    
    myled1=1;  
    Timer t;
    int dt; // delta time
    
/* Put code here to initialize the game state:
   1) you will need to use a psuedo random number generator such as
     rand() to randomly select a goal word from the dictionary.
     The random function needs to be seeded before you call rand(),
     otherwise, rand() will always generate the same series of numbers.
     Call the function set_random_seed -- you need to complete its
     definition below.*/
    set_random_seed();
   //2) call init_keyboard() and show start screen
    init_keyboard();
   
   //3) initialize any other game state that you add.

    
    
/* Insert code into this game loop to complete its implementation:
*/
    while(1){
        t.start(); //start a timer
        draw_lower_status(); //draw the lower status bar
        draw_sprite();
        GameInputs inputs;
        inputs = read_inputs(); //read the inputs of the game
        
        if (inputs.ax > .5 && !inputs.b1 && !inputs.b2 && !inputs.b3) {
            moveleft();
        } else if (inputs.ax < -.5 && !inputs.b1 && !inputs.b2 && !inputs.b3) {
            moveright();
        } else if (inputs.b1) {
            select_letter();
        } else if (inputs.b2) {
            remove_letter();        
        }
        
        /*
        your code here, make decisions based on those inputs, update the keyboard
        make selections, update words etc.
        */
        
        t.stop();
        dt = t.read_ms();
        if (dt < 500) wait_ms(500 - dt);
        
        }
}



/* This should be called in the main function above.
*
* This function sets the random seed for the game using srand(seed).
* One incomplete way to do this is given below: start a Timer and sample it
* to get a seed. The problem is that the same exact time will be read
* every time you reset the mbed.  You need to add code to introduce
* variability into when the timer is stopped.  An easy way to do this
* is to get the user to press a push button to stop the timer at a random
* time.  You can print a prompt to the screen to ask the user to push
* any button to start, then run an infinite while loop that waits for a push 
* button press to break. The Timer is then stopped and read and elapsed time
* used as the seed. (This requires using read_inputs() into a GameInputs variable.)
*/
void set_random_seed() {
    Timer t;
    int start = 1;
    GameInputs startButton;
    t.start(); // start the timer
    
    uLCD.locate(1, 3);
    uLCD.printf("Welcome to MBEDL");
    uLCD.printf("\n Press any Button");
    uLCD.locate(4, 5);
    uLCD.printf("To Start");
    
    while (start) {
        draw_sprite();
        startButton = read_inputs();
        if (startButton.b1 || startButton.b2 || startButton.b3) {
            start = 0;
        }
        wait_ms(200);
    }
    
    t.stop();  //  end the timer
    int seed = t.read_ms(); //read the number of milliseconds elapsed between the start and stop
    srand(seed); // use elapsed time as the seed
    uLCD.cls();
}
// ===User implementations end===
