#ifndef CURRENTREGULATION_H
#define CURRENTREGULATION_H

#include "mbed.h"
#include "BLDCmotorDriver.h"
#include "PI.h"

class CurrentRegulation{
    public:
        CurrentRegulation(PinName I_A, PinName I_B, PinName I_C, PinName I_TOTAL, PinName GH_A, PinName GL_A, PinName GH_B, PinName GL_B,
        PinName GH_C, PinName GL_C, PinName h1, PinName h2, PinName h3, PinName Fault);
        void setValues(double R_sh, double R_1, double R_fs, double R_ft, double V_ref);
        double calculateCurrentA();
        double calculateCurrentB();
        double calculateCurrentC();
        double calculateTotalCurrent();
        double calculateKr();     
        double phaseCurrent(int currentSector);
        void measuring();
        void getValue();
        //void input(double in); 
        void setOutput(double in);  
    private:
        AnalogIn I_A, I_B, I_C, I_TOTAL;
        double R_sh, R_1, R_fs, R_ft, V_ref, I_A_, I_B_, I_C_, I_TOTAL_, zeta, T_suma, T_ch, T_pv, T_I, K_ch, K_R, K_pv, K_a, K_oR, T_d, 
        setPoint, procesValue, I_Ar, u, output;
        int sector;
        Ticker measure;
        PI reg;
        BLDCmotorDriver m;
    };

#endif