#ifndef CURRENTREGULATION_H
#define CURRENTREGULATION_H

#include "mbed.h"

class CurrentRegulation{
    public:
        CurrentRegulation(PinName I_A, PinName I_B, PinName I_C, PinName I_TOTAL);
        CurrentRegulation(PinName I_A, PinName I_B, PinName I_C, PinName I_TOTAL, double R_sh, double R_1, double R_fs, double R_ft, double V_ref);
        void setValues(double R_sh, double R_1, double R_fs, double R_ft, double V_ref);
        void calculateCurrentA();
        void calculateCurrentB();
        void calculateCurrentC();
        void calculateTotalCurrent();
        double calculateKr();  
        double showResult();      
    private:
        AnalogIn I_A, I_B, I_C, I_TOTAL;
        double R_sh, R_1, R_fs, R_ft, V_ref, I_A_, I_B_, I_C_, I_TOTAL_, zeta, T_suma, T_ch, T_pv, T_I, K_ch, K_R, K_pv, K_a, K_oR;
        Ticker measure1, measure2;
    };

#endif