#include "CurrentRegulation.h"

CurrentRegulation::CurrentRegulation(PinName pI_A, PinName pI_B, PinName pI_C, PinName pI_TOTAL):I_A(pI_A), I_B(pI_B), I_C(pI_C), I_TOTAL(pI_TOTAL){
    setValues(1e-3, 1e3, 40e3, 20e3, 3.3);
    measure1.attach_us(this, &CurrentRegulation::calculateCurrentA, 500);
    measure2.attach_us(this, &CurrentRegulation::calculateTotalCurrent, 500);
}

CurrentRegulation::CurrentRegulation(PinName pI_A, PinName pI_B, PinName pI_C, PinName pI_TOTAL, double R_sh, double R_1, double R_fs, double R_ft, double V_ref):I_A(pI_A), I_B(pI_B), I_C(pI_C), I_TOTAL(pI_TOTAL){
    setValues(R_sh, R_1, R_fs, R_ft, V_ref);
    measure1.attach_us(this, &CurrentRegulation::calculateCurrentA, 500);
    measure2.attach_us(this, &CurrentRegulation::calculateTotalCurrent, 500);
}

void CurrentRegulation::setValues(double R_sh, double R_1, double R_fs, double R_ft, double V_ref){
    this->R_sh = R_sh;
    this->R_1 = R_1;
    this->R_fs = R_fs;
    this->R_ft = R_ft;
    this->V_ref = V_ref;    
}

void CurrentRegulation::calculateCurrentA(){
    double V_outa = (V_ref - (V_ref/2))/(1 - 0) * I_A.read() + (V_ref/2);
    this->I_A_ = (R_1 * V_outa)/(R_sh * R_fs) - (R_1 * (V_ref/2))/(R_sh * R_fs);
}

void CurrentRegulation::calculateCurrentB(){
    double V_outb = (V_ref - (V_ref/2))/(1 - 0) * I_B.read() + (V_ref/2);
    this->I_B_ = (R_1 * V_outb)/(R_sh * R_fs) - (R_1 * (V_ref/2))/(R_sh * R_fs);
}

void CurrentRegulation::calculateCurrentC(){
    double V_outc = (V_ref - (V_ref/2))/(1 - 0) * I_C.read() + (V_ref/2);
    this->I_C_ = (R_1 * V_outc)/(R_sh * R_fs) - (R_1 * (V_ref/2))/(R_sh * R_fs);
}

void CurrentRegulation::calculateTotalCurrent(){
    double V_outt = (V_ref - (V_ref/2))/(1 - 0)*I_TOTAL.read()+(V_ref/2);
    this->I_TOTAL_ = (R_1 * V_outt)/(R_sh * R_fs) - (R_1 * (V_ref/2))/(R_sh * R_fs);
}

double showResult(){
    double I_Ar = this->I_A_;
    return I_Ar;
}

double CurrentRegulation::calculateKr(){
    T_pv = 1e-4;
    T_ch = 25e-6;
    zeta = 1.2;
    K_ch = 50.0;
    K_pv = 1.0;
    T_I = 1.428e-3;
    K_a = 4.76;
    T_suma = (T_pv + T_ch);
    K_oR = 1/(4 * (zeta * zeta) * T_suma);
    return K_R = (K_oR * T_I)/(K_a * K_ch * K_pv);
}

/*
void CurrentMeasurement::phaseCurrent(int currentSector){
    switch(currentSector){  
           case 0:                
                measureCurrentC();
                break;
           case 1:            
                measureCurrentC(); 
                break;
           case 2:   
                measureCurrentA();   
                break;
            case 3:             
                measureCurrentA(); 
                break;
            case 4:              
                measureCurrentB();  
                break;    
            case 5:              
                measureCurrentB();  
                break;
        }
}
*/