/******************************************************************************
*
*   Copyright (C) 2014 Texas Instruments Incorporated
*
*   All rights reserved. Property of Texas Instruments Incorporated.
*   Restricted rights to use, duplicate or disclose this code are
*   granted through contract.
*
*   The program may not be used without the written permission of
*   Texas Instruments Incorporated or against the terms and conditions
*   stipulated in the agreement under which this program has been supplied,
*   and under no circumstances can it be used with non-TI connectivity device.
*
******************************************************************************/

#ifndef __SERVER_PLUG_H__
#define __SERVER_PLUG_H__

#include "server_pkts.h"

#ifdef __cplusplus
extern "C"
{
#endif

namespace mbed_mqtt {

/* Used by Server Core Logic */

#define PG_MAP_BITS_SIZE     2
#define PG_MAP_BITS_MASK     ((1 << PG_MAP_BITS_SIZE) - 1)
#define PG_MAP_MAX_ELEMS     4  /* should be able accomodate in 1 byte */
#define PG_MAP_ALL_DFLTS     ((1 << (PG_MAP_BITS_SIZE * PG_MAP_MAX_ELEMS)) - 1)

#define PG_MAP_HAS_VALUE(pg_map, index)                 \
        (((~pg_map) >> (index * PG_MAP_BITS_SIZE)) & PG_MAP_BITS_MASK)

#define PG_MAP_VAL_SETUP(pg_map, qid, index)                            \
        {                                                               \
                uint32_t ofst = index * PG_MAP_BITS_SIZE;                    \
                pg_map  &= ~(PG_MAP_BITS_MASK << ofst);                 \
                pg_map  |= qid << ofst;                                 \
        }

#define PG_MAP_VAL_RESET(pg_map, index)                                 \
        pg_map |= PG_MAP_BITS_MASK << (index * PG_MAP_BITS_SIZE);

#if (PG_MAP_BITS_MASK != QID_VMASK)
#error "PG_MAP_BITS_MASK must be same as 2bit QOS_VMASK"
#endif

#if ((PG_MAP_MAX_ELEMS * PG_MAP_BITS_SIZE) > 8)
#error "Make size-of pg_map greate than 1 byte"
#endif

struct plugin_core_msg_cbs {

        int32_t (*topic_enroll)(uint8_t pg_id, const struct utf8_string *topic,
                            enum mqtt_qos qos);
        int32_t (*topic_cancel)(uint8_t pg_id, const struct utf8_string *topic);
        int32_t (*publish)(const struct utf8_string *topic,    const uint8_t *data_buf,
                       uint32_t data_len, enum mqtt_qos qos, bool retain);
};

int32_t plugin_init(const struct plugin_core_msg_cbs *cbs);

/* uint16_t composition: MSB is CONNACK-Flags = 0, LSB is CONNACK-RC */
uint16_t plugin_connect(const struct utf8_string *clientId, 
                   const struct utf8_string *username,
                   const struct utf8_string *password,
                   void **app_usr);

int32_t plugin_publish(uint8_t pg_map, const struct utf8_string *topic,
                   const uint8_t *payload, uint32_t pay_len,
                   bool dup, uint8_t qos, bool retain);

int32_t plugin_disconn(const void *app_usr, bool due2err);

}//namespace mbed_mqtt 

#ifdef __cplusplus  
}
#endif 

#endif


