/*
 * spi.c - msp430f5529 experiment board spi interface implementation
 *
 * Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
*/

#include "cc3100_simplelink.h"
#include "cc3100_spi.h"
#include "BoardInit.h"

#if (THIS_BOARD == MBED_BOARD_LPC1768) 
    cc3100_spi spi_(p9, p10, p8, SPI(p5, p6, p7));//LPC1768  nHib, irq, cs, mosi, miso, sck 
/*    cc3100_spi spi_(p9, p10, p8, SPI(p11, p12, p13));//LPC1768  nHib, irq, cs, mosi, miso, sck. Alt spi pins */
#elif (THIS_BOARD == ST_MBED_NUCLEOF411)
    cc3100_spi spi_(PA_9, PC_7, PB_6, SPI(PA_7, PA_6, PA_5));//nucleoF411  nHib, irq, cs, mosi, miso, sck 
#elif (THIS_BOARD == EA_MBED_LPC4088)
    cc3100_spi spi_(p9, p10, p8, SPI(p5, p6, p7));
#elif (THIS_BOARD == ST_MBED_NUCLEOF103)     
    cc3100_spi spi_(PA_9, PC_7, PB_6, SPI(PA_7, PA_6, PA_5));   
#else    
      
#endif  
    
P_EVENT_HANDLER             pIraEventHandler = 0; 
uint8_t                         IntIsMasked;

cc3100_spi::cc3100_spi(PinName cc3100_irq, PinName cc3100_en, PinName cc3100_cs, SPI cc3100_spi)
  : _wlan_irq(cc3100_irq), _wlan_nHIB(cc3100_en), _wlan_cs(cc3100_cs), _wlan_spi(cc3100_spi){

    _wlan_spi.format(8,1);
    _wlan_spi.frequency(12000000);
    _wlan_irq.rise(&IntSpiGPIOHandler);      //_SlDrvRxIrqHandler is triggered after IntSpiGPIOHandler
    _wlan_nHIB = 0;
    _wlan_cs = 1;
    wait_ms(200);
}

cc3100_spi::~cc3100_spi() {

}
/*
int cc3100_spi::spi_Close(Fd_t fd)
{
    // Disable WLAN Interrupt ... 
    cc3100_InterruptDisable();

    return NONOS_RET_OK;
}
*/
void cc3100_spi::cc3100_InterruptEnable()
{
      __enable_irq();
}

void cc3100_spi::cc3100_InterruptDisable()
{ 
      __disable_irq();
}
/*
void cc3100_spi::CC3100_disable()
{
      _wlan_en = 0;
}
*/
/*
void CC3100_enable()
{
      _wlan_en = 1;
}
*/
/*
Fd_t cc3100_spi::spi_Open(char *ifName, unsigned long flags)
{

    // 50 ms delay 
    wait_ms(50);

    // Enable WLAN interrupt 
    cc3100_InterruptEnable();

    return NONOS_RET_OK;
}
*/
/*
int cc3100_spi::spi_Write(Fd_t fd, unsigned char *pBuff, int len)
{
    int len_to_return = len;

    _wlan_cs = 0;
    
    while(len)
   {
        _wlan_spi.write(*pBuff++);
        len--;
   }

    _wlan_cs = 1;

    return len_to_return;
}

int cc3100_spi::spi_Read(Fd_t fd, unsigned char *pBuff, int len)
{
    int i = 0;

    _wlan_cs = 0;
    
    for (i = 0; i < len; i++)
   {
        pBuff[i] = _wlan_spi.write(0xFF);
   }

    _wlan_cs = 1;

    return len;
}
*/

void IntSpiGPIOHandler(void)
{
       switch(spi_._wlan_irq){
        
        case 1:
          if(pIraEventHandler)
          {
            pIraEventHandler(0);
          }
        break;
    default:
        break;
    }           
}

/*!
    \brief register an interrupt handler for the host IRQ

    \param[in]      InterruptHdl    -    pointer to interrupt handler function

    \param[in]      pValue          -    pointer to a memory strcuture that is
                    passed to the interrupt handler.

    \return         upon successful registration, the function shall return 0.
                    Otherwise, -1 shall be returned

    \sa
    \note           If there is already registered interrupt handler, the
                    function should overwrite the old handler with the new one
    \warning
*/
int registerInterruptHandler(P_EVENT_HANDLER InterruptHdl , void* pValue)
{
//    printf("Register Interrupt Handler Called\r\n");
    pIraEventHandler = InterruptHdl;
    return 0;
}

/*!
    \brief     Unmasks the Host IRQ

    \param[in]      none

    \return         none

    \warning
*/
void UnMaskIntHdlr()
{
    IntIsMasked = FALSE;
}

/*!
    \brief      Masks the Host IRQ

    \param[in]      none

    \return         none

    \warning
*/
void MaskIntHdlr()
{
    IntIsMasked = TRUE;
}

void CC3100_disable()
{
 
     spi_._wlan_nHIB = 0;
      
}

void CC3100_enable()
{
       
      spi_._wlan_nHIB = 1;
        
}

Fd_t spi_Open(char *ifName, unsigned long flags)
{

    /* 50 ms delay */
    wait_ms(50);

    /* Enable WLAN interrupt */
    spi_.cc3100_InterruptEnable();

    return NONOS_RET_OK;
}

int spi_Close(Fd_t fd)
{

    wait_ms(2);
    /* Disable WLAN Interrupt ... */
    spi_.cc3100_InterruptDisable();

    return NONOS_RET_OK;
}

int spi_Write(Fd_t fd, unsigned char *pBuff, int len)
{

    int len_to_return = len;

    spi_._wlan_cs = 0;
    
    wait_us(50);
    
    while(len)
   {
        spi_._wlan_spi.write(*pBuff++);
        len--;

   }
   
    spi_._wlan_cs = 1;

    return len_to_return;
}

int spi_Read(Fd_t fd, unsigned char *pBuff, int len)
{
    
    spi_._wlan_cs = 0;
    
    wait_us(50);
    
    for (int i = 0; i < len; i++){
        pBuff[i] = spi_._wlan_spi.write(0xFF);

    }

    spi_._wlan_cs = 1;

    return len;
}

//}//namespace