#include "mbed.h"
#include "Led_config.h"

DigitalOut GPIO_LED3(PA_15);//GREEN LED
DigitalOut GPIO_LED2(PB_14);//ORANGE LED
DigitalOut GPIO_LED1(PB_15);//RED LED

//*****************************************************************************
//
//! Turn LED On
//!
//! \param  ledNum is the LED Number
//!
//! \return none
//!
//! \brief  Turns a specific LED On
//
//*****************************************************************************
void
GPIO_IF_LedOn(char ledNum)
{
    switch(ledNum)
    {
        case MCU_ON_IND:
        case MCU_EXECUTE_SUCCESS_IND:
        case MCU_GREEN_LED_GPIO:
        {
          /* Switch ON GREEN LED */
          GPIO_LED3 = 1;
          break;
        }
        case MCU_SENDING_DATA_IND:
        case MCU_EXECUTE_FAIL_IND:
        case MCU_ORANGE_LED_GPIO:
        {
          /* Switch ON ORANGE LED */
          GPIO_LED2 = 1;
          break;
        }
        case MCU_ASSOCIATED_IND:
        case MCU_IP_ALLOC_IND:
        case MCU_SERVER_INIT_IND:
        case MCU_CLIENT_CONNECTED_IND:
        case MCU_RED_LED_GPIO:
        {
          /* Switch ON RED LED */
          GPIO_LED1 = 1;
          break;
        }
        case MCU_ALL_LED_IND:
        {
          /* Switch ON ALL LEDs LED */
          GPIO_LED1 = 1;
          GPIO_LED2 = 1;
          GPIO_LED3 = 1;
          break;
        }
        default:
          break;
    }
}

//*****************************************************************************
//
//! Turn LED Off
//!
//! \param  ledNum is the LED Number
//!
//! \return none
//!
//! \brief  Turns a specific LED Off
//
//*****************************************************************************
void
GPIO_IF_LedOff(char ledNum)
{
  switch(ledNum)
  {
    case MCU_ON_IND:
    case MCU_EXECUTE_SUCCESS_IND:
    case MCU_GREEN_LED_GPIO:
    {
      /* Switch OFF GREEN LED */
      GPIO_LED3 = 0;
      break;
    }
    case MCU_SENDING_DATA_IND:
    case MCU_EXECUTE_FAIL_IND:
    case MCU_ORANGE_LED_GPIO:
    {
      /* Switch OFF ORANGE LED */
      GPIO_LED2 = 0;
      break;
    }
    case MCU_ASSOCIATED_IND:
    case MCU_IP_ALLOC_IND:
    case MCU_SERVER_INIT_IND:
    case MCU_CLIENT_CONNECTED_IND:
    case MCU_RED_LED_GPIO:
    {
      /* Switch OFF RED LED */
      GPIO_LED1 = 0;
      break;
    }
    case MCU_ALL_LED_IND:
    {
      /* Switch OFF ALL LEDs LED */
      GPIO_LED3 = 0;
      GPIO_LED2 = 0;
      GPIO_LED1 = 0;
      break;
    }
    default:
      break;
  }
}

//*****************************************************************************
//
//!  \brief This function returns LED current Status
//!
//!  \param[in] ucGPIONum is the GPIO to which the LED is connected
//!                MCU_GREEN_LED_GPIO\MCU_ORANGE_LED_GPIO\MCU_RED_LED_GPIO
//!
//!
//!  \return 1: LED ON, 0: LED OFF
//
//*****************************************************************************
unsigned char
GPIO_IF_LedStatus(unsigned char ucGPIONum)
{
  unsigned char ucLEDStatus;
  switch(ucGPIONum)
  {
    case MCU_GREEN_LED_GPIO:
    {
      if(GPIO_LED3.read()){
         ucLEDStatus = 1;
      }else{
         ucLEDStatus = 0;
      }   
      break;
    }
    case MCU_ORANGE_LED_GPIO:
    {
      if(GPIO_LED2.read()){
         ucLEDStatus = 1;
      }else{
         ucLEDStatus = 0;
      }   
      break;
    }
    case MCU_RED_LED_GPIO:
    {
      if(GPIO_LED1.read()){
         ucLEDStatus = 1;
      }else{
         ucLEDStatus = 0;
      }   
      break;
    }
    default:
        ucLEDStatus = 0;
  }
  return ucLEDStatus;
}

//*****************************************************************************
//
//! Toggle the Led state
//!
//! \param  ledNum is the LED Number
//!
//! \return none
//!
//! \brief  Toggles a board LED
//
//*****************************************************************************
void GPIO_IF_LedToggle(unsigned char ucLedNum)
{

    unsigned char ucLEDStatus = GPIO_IF_LedStatus(ucLedNum);
    if(ucLEDStatus == 1)
    {
        GPIO_IF_LedOff(ucLedNum);
    }
    else
    {
        GPIO_IF_LedOn(ucLedNum);
    }
}

