#ifndef __MT9D111_H__
#define __MT9D111_H__

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

#define MT9D111_ID                      0x1519
  /* firmware drivers ID */
#define MON_DRV_ID                      0
#define SEQ_DRV_ID                      1
#define AE_DRV_ID                       2
#define AWB_DRV_ID                      3
#define FD_DRV_ID                       4
#define AF_DRV_ID                       5
#define AFM_DRV_ID                      6
#define MODE_DRV_ID                     7
  
  /* Monitor driver variables */
#define MON_VER_OFFSET                  12
  
  /* Sequencer driver variables */
#define SEQ_MODE_OFFSET                 2
#define SEQ_STATE_OFFSET                4
  
  /* Sequencer Driver states */
#define SEQ_STATE_INIT                  0
#define SEQ_STATE_TO_PREVIEW            1
#define SEQ_STATE_ENTER_PREVIEW         2
#define SEQ_STATE_PREVIEW               3
#define SEQ_STATE_LEAVE_PREVIEW         4
#define SEQ_STATE_TO_CAPTURE            5
#define SEQ_STATE_ENTER_CAPTURE         6
#define SEQ_STATE_CAPTURE               7
#define SEQ_STATE_LEAVE_CAPTURE         8
#define SEQ_STATE_STANDBY               9

/* pages */
#define PAGE_SENSOR_CORE                0
#define PAGE_IFP1                       1
#define PAGE_IFP2                       2

#define REG_PAGE                        0xF0
#define REG_VAR_ADDR                    0xC6
#define REG_VAR_DATA                    0xC8 

/* Bits for Microcontroller variable access using logic address */
#define VAR_LENGTH_16BIT                0
#define VAR_LENGTH_8BIT                 1
#define VAR_LENGTH_SHIFT                15
#define VAR_ADDRESS_TYPE_LOGIC          1
#define VAR_ADDRESS_TYPE_SHIFT          13
#define VAR_DRV_ID_SHIFT                8
#define VAR_ADDRESS_SHIFT               0

typedef struct MT9D111RegLst
{
    unsigned char ucPageAddr;
    unsigned char ucRegAddr;
    unsigned short usValue;
} s_RegList;

void getCamId(void);
static int wait_for_seq_state(int state);
static uint16_t read_firmware_var(int id, int offset, int byte);
int Start_still_capture(int frames);
int Stop_still_capture(void);
int cam_power_on(void);
int cam_power_off(void);
void cam_exit_standby(void);
void cam_enter_standby(void);

/*!
    \brief                      This function initilizes the camera sensor

    \param[in]                  None

    \return                     0 - Success
                               -1 - Error

    \note
    \warning
*/
int CameraSensorInit();

/*!
    \brief                      Configures sensor in JPEG mode

    \param[in]                  None

    \return                     0 - Success
                               -1 - Error

    \note
    \warning
*/
int StartSensorInJpegMode(int width, int height);
int StartCaptureCmd(void);
int CameraSensorResolution(int width, int height);
static int RegLstWrite(s_RegList *pRegLst, unsigned int ulNofItems);
//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif


#endif //__MT9D111_H__


