
#include "mbed.h"

// Standard includes
#include <stdarg.h>

#include "myBoardInit.h"
#include "cli_uart.h"
#include "osi.h"

OsiLockObj_t    g_printLock;

#if (THIS_BOARD == Seeed_Arch_Max)
Serial uart(PC_6, PC_7);//uart 6
//Serial uart(USBTX, USBRX);
#elif (THIS_BOARD == EA_MBED_LPC4088)
Serial uart(p37, p31);
#endif

int Uart_Write(unsigned char *inBuff)
{
    uint16_t ret, ecount, usLength = strlen((const char *)inBuff);
    ecount = 0;
    ret = 0;
    
    while(!(uart.writeable())){ecount++;if(ecount>3000)break;};

    if(uart.writeable()) {

        if(inBuff == NULL) {
            printf("Uart Write buffer empty\r\n");
            return -1;
        }

        RTOS_MUTEX_ACQUIRE(&g_printLock);
        ret = usLength;

        while (usLength) {
            uart.putc(*inBuff);
            usLength--;
            inBuff++;
        }

        RTOS_MUTEX_RELEASE(&g_printLock);
    } else {
        printf("Uart Write failed [uart not writeable] now trying printf\r\n");
        while (usLength) {
            printf("%c",*inBuff);
            usLength--;
            inBuff++;
        }
        return -1;
    }
    
    return (int)ret;

}

void CLI_Configure(void)
{
    uart.baud(115200);
    
    RTOS_MUTEX_CREATE(&g_printLock);

}

//*****************************************************************************
//
//!    prints the formatted string on to the console
//!
//! \param format is a pointer to the character string specifying the format in
//!           the following arguments need to be interpreted.
//! \param [variable number of] arguments according to the format in the first
//!         parameters
//! This function
//!        1. prints the formatted error statement.
//!
//! \return count of characters printed
//
//*****************************************************************************
int Report(const char *pcFormat, ...)
{
 int iRet = 0;
//#ifndef NOTERM

  char *pcBuff, *pcTemp;
  int iSize = 256;
 
  va_list list;
  pcBuff = (char*)malloc(iSize);
  if(pcBuff == NULL)
  {
      return -1;
  }
  while(1)
  {
      va_start(list,pcFormat);
      iRet = vsnprintf((char*)pcBuff,iSize,pcFormat,list);
      va_end(list);
      if(iRet > -1 && iRet < iSize)
      {
          break;
      }
      else
      {
          iSize*=2;
          if((pcTemp=(char*)realloc(pcBuff,iSize))==NULL)
          { 
              Message("Could not reallocate memory\n\r");
              iRet = -1;
              break;
          }
          else
          {
              pcBuff=pcTemp;
          }
          
      }
  }
  Message(pcBuff);
  free(pcBuff);
  
//#endif
  return iRet;
}

//*****************************************************************************
//
//!    Outputs a character string to the console
//!
//! \param str is the pointer to the string to be printed
//!
//! This function
//!        1. prints the input string character by character on to the console.
//!
//! \return none
//
//*****************************************************************************
void 
Message(const char *str)
{
    
    uint16_t ecount = 0;
    
//#ifndef NOTERM
    while(!(uart.writeable())){ecount++;if(ecount>3000)break;};

    if(uart.writeable()) {

       if(str != NULL){
          RTOS_MUTEX_ACQUIRE(&g_printLock);
          while(*str!='\0')
          {
            uart.putc(*str++);
          }
          RTOS_MUTEX_RELEASE(&g_printLock);
       }
   }    
//#endif
}


