//*****************************************************************************
// i2cconfig.c
//
// I2C features APIs
//
// Copyright (C) 2014 Texas Instruments Incorporated - http://www.ti.com/ 
// 
// 
//  Redistribution and use in source and binary forms, with or without 
//  modification, are permitted provided that the following conditions 
//  are met:
//
//    Redistributions of source code must retain the above copyright 
//    notice, this list of conditions and the following disclaimer.
//
//    Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the 
//    documentation and/or other materials provided with the   
//    distribution.
//
//    Neither the name of Texas Instruments Incorporated nor the names of
//    its contributors may be used to endorse or promote products derived
//    from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
//  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
//  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
//  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
//  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
//  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
//  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
//  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
//  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//*****************************************************************************
//*****************************************************************************
//
//! \addtogroup i2cconfig
//! @{
//
//*****************************************************************************
#include <stdbool.h>
#include <stdint.h>
#include "mbed.h"

#include "cli_uart.h"
#include "osi.h"

#include "i2cconfig.h"
#include "cli_uart.h"
#include "myBoardInit.h"



I2C i2c(PB_9, PB_8);

OsiLockObj_t    g_i2cLock;


//*****************************************************************************
//
//!     I2CInit
//!    
//!	\param                      Delay  
//!     \return                     None                            
//
//*****************************************************************************
uint32_t I2CInit()
{

    i2c.frequency (100000);

    return 0;
}
//****************************************************************************
//
//! Invokes the I2C driver APIs to read from the device. This assumes the 
//! device local address to read from is set using the I2CWrite API.
//!
//! \param      ucDevAddr is the device I2C slave address
//! \param      ucBuffer is the pointer to the read data to be placed
//! \param      ulSize is the length of data to be read
//! \param      ucFlags Flag
//! 
//! This function works in a polling mode,
//!    1. Writes the device register address to be written to.
//!    2. In a loop, reads all the bytes over I2C
//!
//! \return 0: Success, < 0: Failure.
//
//****************************************************************************
int32_t I2CBufferRead(int32_t ucDevAddr, uint8_t *ucBuffer,
                            int32_t ulSize, unsigned char ucFlags)
{
//  Uart_Write((uint8_t*)"I2CBufferRead \n\r");
/*   
    i2c.start();       
    
    // Set I2C slave read address
    i2c.write(ucDevAddr);
    if(ulSize == 1){
    	ucBuffer[0] = i2c.read(0);
    }else{	
        for(int i=0;i<ulSize;i++){
           ucBuffer[i] = i2c.read(0);
        }
    }    
    
    i2c.stop();
*/
    int32_t err = 0;
    
//    RTOS_MUTEX_ACQUIRE(&g_i2cLock);
        
    err = i2c.read(ucDevAddr,(char*)ucBuffer,ulSize);
    if(err == 1){
       Uart_Write((uint8_t*)"Return error I2C read\n\r");
//       RTOS_MUTEX_RELEASE(&g_i2cLock);
       return -1;
    }
    wait_ms(1);
//    RTOS_MUTEX_RELEASE(&g_i2cLock);   
    return 0;
}
//****************************************************************************
//
//! Invokes the I2C driver APIs to write to the specified address
//!
//! \param ucDevAddr is the device I2C slave address
//! \param ucBuffer is the pointer to the data to be written
//! \param ulSize is the length of data to be written
//! \param ucFlags
//! 
//! This function works in a polling mode,
//!    1. Writes the device register address to be written to.
//!    2. In a loop, writes all the bytes over I2C
//!
//! \return 0: Success, < 0: Failure.
//
//****************************************************************************

int32_t I2CBufferWrite(int32_t ucDevAddr, uint8_t *ucBuffer,
                             int32_t ulSize,unsigned char ucFlags)
{
//  Uart_Write((uint8_t*)"I2CBufferWrite \n\r");
/*
    i2c.start();       
   
   // Set I2C slave write address
    i2c.write(ucDevAddr);

    if(ulSize == 1){
    	i2c.write(ucBuffer[0]);
    }else{	
        for(int i=0;i<ulSize;i++){
           i2c.write(ucBuffer[i]);
        }
    }    

        i2c.stop();
*/        
    int32_t err = 0;
    
//    RTOS_MUTEX_ACQUIRE(&g_i2cLock);      
    err = i2c.write(ucDevAddr,(char*)ucBuffer,ulSize);
    if(err == 1){
    	Uart_Write((uint8_t*)"Return error I2C write\n\r");
//    	RTOS_MUTEX_RELEASE(&g_i2cLock);
    	return -1;   	
    }
    wait_ms(1);
//    RTOS_MUTEX_RELEASE(&g_i2cLock);		
    return 0;
}

//*****************************************************************************
//
// Close the Doxygen group.
//! @}
//
//*****************************************************************************


